/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.openjdk.jmc.joverflow.ui.swt.TreemapItem;
import org.openjdk.jmc.joverflow.ui.swt.TreemapToolTip;
import org.openjdk.jmc.joverflow.ui.swt.events.TreemapEvent;
import org.openjdk.jmc.joverflow.ui.swt.events.TreemapListener;

public class Treemap
extends Canvas {
    private static final int TRIM = 2;
    private TreemapItem rootItem = new TreemapItem(this, 0);
    private Map<SelectionListener, TypedListener> selectionListeners = new HashMap<SelectionListener, TypedListener>();
    private Set<TreemapListener> treemapListeners = new HashSet<TreemapListener>();
    private TreemapItem topItem = this.rootItem;
    private TreemapItem selectedItem = null;
    private boolean borderVisible = true;
    private boolean toolTipEnabled = true;
    private Cursor cursor;
    private TreemapToolTip toolTip = new TreemapToolTip((Control)this);

    public Treemap(Composite parent, int style) {
        super(Treemap.checkNull(parent), style);
        if ((style & 0x10000000) == 0x10000000) {
            throw new UnsupportedOperationException("SWT.VIRTUAL is not support by Treemap");
        }
        this.addPaintListener(this::onPaintControl);
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                Treemap.this.onMouseDoubleClick(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                Treemap.this.onMouseDown(mouseEvent);
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.addMouseMoveListener(this::onMouseMove);
    }

    static Composite checkNull(Composite control) {
        if (control == null) {
            SWT.error((int)4);
        }
        return control;
    }

    static Treemap checkNull(Treemap treemap) {
        if (treemap == null) {
            SWT.error((int)4);
        }
        return treemap;
    }

    private void onPaintControl(PaintEvent paintEvent) {
        this.getTopItem().paintItem(paintEvent.gc, this.getClientArea(), true);
    }

    private void onMouseDoubleClick(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        TreemapItem item = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
        if (item == null) {
            return;
        }
        this.setTopItem(item);
    }

    private void onMouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1) {
            TreemapItem item = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
            if (item == null) {
                return;
            }
            this.setSelection(item);
            return;
        }
        if (mouseEvent.button == 2) {
            this.setTopItem(this.getRootItem());
            return;
        }
        if (mouseEvent.button == 3) {
            TreemapItem parentItem = this.getTopItem().getParentItem();
            if (parentItem == null) {
                return;
            }
            this.setTopItem(parentItem);
            return;
        }
    }

    private void onMouseMove(MouseEvent mouseEvent) {
        TreemapItem item = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
        if (item == null) {
            return;
        }
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        this.cursor = item.getItemCount() == 0 ? new Cursor((Device)Display.getCurrent(), 0) : new Cursor((Device)Display.getCurrent(), 2);
        this.setCursor(this.cursor);
        if (this.toolTipEnabled) {
            this.toolTip.setItem(item);
        }
    }

    private Event createEventForItem(int type, TreemapItem item) {
        Event e = new Event();
        e.display = this.getDisplay();
        e.widget = this;
        e.type = type;
        e.item = item;
        e.index = this.indexOf(item);
        if (item != null) {
            e.data = item.getData();
        }
        if (item != null && item.getBounds() != null) {
            Rectangle bounds = item.getBounds();
            e.x = bounds.x;
            e.y = bounds.y;
            e.width = bounds.width;
            e.height = bounds.height;
        }
        return e;
    }

    public Rectangle getClientArea() {
        Rectangle bounds = super.getClientArea();
        bounds.x += 2;
        bounds.y += 2;
        bounds.width -= 4;
        bounds.height -= 4;
        return bounds;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return new Rectangle(x - 2, y - 2, width + 4, height + 4);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.putIfAbsent(listener, new TypedListener((EventListener)listener));
        TypedListener typedListener = this.selectionListeners.get(listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        TypedListener typedListener;
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if ((typedListener = this.selectionListeners.remove(listener)) == null) {
            return;
        }
        this.removeListener(13, (Listener)typedListener);
        this.removeListener(14, (Listener)typedListener);
    }

    public void addTreemapListener(TreemapListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.treemapListeners.add(listener);
    }

    public void removeTreemapListener(TreemapListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.treemapListeners.remove(listener);
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.rootItem.clear(index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.rootItem.clearAll(all);
    }

    public void dispose() {
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        super.dispose();
    }

    public void deselect(int index) {
        this.checkWidget();
        try {
            this.getItem(index);
            this.deselect();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    public void deselect() {
        this.checkWidget();
        if (this.getSelection() != null) {
            this.setSelection(null);
        }
    }

    public void select(int index) {
        this.checkWidget();
        try {
            this.setSelection(this.getItem(index));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    public TreemapItem getItem(int index) {
        this.checkWidget();
        return this.rootItem.getItem(index);
    }

    public TreemapItem getItem(Point point) {
        this.checkWidget();
        return this.topItem.getItem(point);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.rootItem.getItemCount();
    }

    public TreemapItem[] getItems() {
        this.checkWidget();
        return this.rootItem.getItems();
    }

    public boolean getBordersVisible() {
        this.checkWidget();
        return this.borderVisible;
    }

    public void setBordersVisible(boolean show) {
        this.checkWidget();
        this.borderVisible = show;
    }

    public boolean getToolTipEnabled() {
        this.checkWidget();
        return this.toolTipEnabled;
    }

    public void setToolTipEnabled(boolean enabled) {
        this.checkWidget();
        this.toolTipEnabled = enabled;
        if (enabled) {
            this.toolTip.activate();
        } else {
            this.toolTip.deactivate();
        }
    }

    public TreemapItem getRootItem() {
        this.checkWidget();
        return this.rootItem;
    }

    public TreemapItem getSelection() {
        this.checkWidget();
        return this.selectedItem;
    }

    public void setSelection(TreemapItem item) {
        this.checkWidget();
        if (item != null && item.getParent() != this) {
            return;
        }
        this.selectedItem = item;
        Event e = this.createEventForItem(13, item);
        this.notifyListeners(13, e);
        this.redraw();
    }

    public String getText() {
        this.checkWidget();
        return this.rootItem.getText();
    }

    public void setText(String message) {
        this.checkWidget();
        this.rootItem.setText(message);
    }

    public TreemapItem getTopItem() {
        this.checkWidget();
        return this.topItem;
    }

    public void setTopItem(TreemapItem item) {
        this.checkWidget();
        item = TreemapItem.checkNull(item);
        if (item.getParent() != this) {
            throw new IllegalArgumentException("the given TreemapItem does not belong to the receiver");
        }
        if (item.getItemCount() == 0 && item.getParentItem() != null) {
            item = item.getParentItem();
        }
        TreemapItem oldItem = this.topItem;
        this.topItem = item;
        if (oldItem == this.topItem) {
            return;
        }
        Event e = this.createEventForItem(0, this.topItem);
        for (TreemapListener listener : this.treemapListeners) {
            listener.treemapTopChanged(new TreemapEvent(e));
        }
        this.redraw();
    }

    public String getToolTip() {
        this.checkWidget();
        return this.rootItem.getToolTipText();
    }

    public void setToolTip(String message) {
        this.checkWidget();
        this.rootItem.setToolTipText(message);
    }

    public int indexOf(TreemapItem item) {
        this.checkWidget();
        return this.rootItem.indexOf(item);
    }

    public void remove(int index) {
        this.checkWidget();
        this.rootItem.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.rootItem.removeAll();
    }

    public void showItem(TreemapItem item) {
        this.checkWidget();
        item = TreemapItem.checkNull(item);
        if (item.getParent() != this) {
            throw new IllegalArgumentException("the given TreemapItem does not belong to the receiver");
        }
        TreemapItem top = item.getParentItem();
        if (top == null) {
            top = item;
        }
        this.setTopItem(top);
        if (item.getBounds() == null) {
            this.setTopItem(top);
        }
    }

    public void showSelection() {
        this.checkWidget();
        TreemapItem selection = this.getSelection();
        if (selection == null) {
            return;
        }
        this.showItem(selection);
    }
}

