/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.ClusterType;
import org.openjdk.jmc.joverflow.ui.model.MemoryStatisticsItem;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.viewers.BaseViewer;
import org.openjdk.jmc.joverflow.ui.viewers.MemoryStatisticsTableViewer;

public class OverheadTypeViewer
extends BaseViewer {
    private final MemoryStatisticsTableViewer mTableViewer;
    private final MemoryStatisticsItem[] mItems = new MemoryStatisticsItem[ClusterType.values().length];
    private ClusterType mCurrentType = ClusterType.ALL_OBJECTS;
    private boolean mAllIncluded = false;

    public OverheadTypeViewer(Composite parent, int style) {
        ClusterType[] clusterTypeArray = ClusterType.values();
        int n = clusterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterType t = clusterTypeArray[n2];
            this.mItems[t.ordinal()] = new MemoryStatisticsItem((Object)t, 0L, 0L, 0);
            ++n2;
        }
        this.mTableViewer = new MemoryStatisticsTableViewer(parent, style | 0x10000 | 0x800);
        this.mTableViewer.setPrimaryColumnText("Object Selection");
        this.mTableViewer.addSelectionChangedListener(event -> this.setCurrentType(this.getSelectedType()));
    }

    public Control getControl() {
        return this.mTableViewer.getControl();
    }

    public void refresh() {
        this.mTableViewer.refresh();
    }

    public ISelection getSelection() {
        return this.mTableViewer.getSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.mTableViewer.setSelection(selection, reveal);
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        if (this.mAllIncluded) {
            MemoryStatisticsItem[] memoryStatisticsItemArray = this.mItems;
            int n = this.mItems.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryStatisticsItem item = memoryStatisticsItemArray[n2];
                item.reset();
                ++n2;
            }
            this.mAllIncluded = false;
        }
        if (oc.getType() != null) {
            this.mItems[oc.getType().ordinal()].addObjectCluster(oc);
        }
    }

    @Override
    public void allIncluded() {
        ((MemoryStatisticsTableViewer.MemoryStatisticsContentProvider)this.mTableViewer.getContentProvider()).setInput(this.mItems);
        this.mAllIncluded = true;
    }

    @Override
    public void setHeapSize(long size) {
        this.mTableViewer.setHeapSize(size);
    }

    public ClusterType getCurrentType() {
        return this.mCurrentType;
    }

    public void setCurrentType(ClusterType type) {
        ClusterType oldType = this.mCurrentType;
        this.mCurrentType = type;
        if (oldType != this.mCurrentType) {
            this.notifyFilterChangedListeners();
        }
    }

    private ClusterType getSelectedType() {
        IStructuredSelection selection;
        MemoryStatisticsItem item;
        ClusterType type = ClusterType.ALL_OBJECTS;
        if (!this.getSelection().isEmpty() && this.getSelection() instanceof IStructuredSelection && (item = (MemoryStatisticsItem)(selection = (IStructuredSelection)this.getSelection()).getFirstElement()) != null && item.getId() != null) {
            type = (ClusterType)((Object)item.getId());
        }
        return type;
    }

    @Override
    public boolean filter(ObjectCluster oc) {
        return this.getCurrentType() == oc.getType();
    }

    @Override
    public void reset() {
        this.setCurrentType(ClusterType.ALL_OBJECTS);
    }
}

