/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.action;

import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.action.TriggerActionRecordingToolkit;
import org.openjdk.jmc.flightrecorder.configuration.FlightRecorderException;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import org.openjdk.jmc.flightrecorder.configuration.recording.RecordingOptionsBuilder;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.triggers.IActivatableTriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;

public class TriggerActionStartContinuousRecording
extends TriggerAction
implements IActivatableTriggerAction {
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            NotificationPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        try {
            RecordingOptionsBuilder b = new RecordingOptionsBuilder((IRecorderConfigurationService)service);
            b.duration(0L);
            Object name = this.getSetting("name").getString();
            if (++this.recordingNumber > 1) {
                name = (String)name + " " + this.recordingNumber;
            }
            b.name((String)name);
            service.start(b.build(), TriggerActionRecordingToolkit.getTemplate("Continuous", service));
        }
        catch (QuantityConversionException e) {
            throw new FlightRecorderException(null, (Throwable)e);
        }
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.supportsJfrAction(handle);
    }

    public boolean isActivatable(IConnectionHandle handle) {
        return TriggerActionRecordingToolkit.isActivatableJfrAction(handle);
    }
}

