/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.wizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.wizard.Messages;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.ui.common.util.StatusFactory;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.wizards.SimpleImportFromFileWizardPage;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RuleImportWizard
extends Wizard
implements IImportWizard {
    private static final String RULE_CANT_BE_IMPORTED = "* {0}\\{1}";
    private SimpleImportFromFileWizardPage m_wizardPage;

    public boolean performFinish() {
        File file = this.m_wizardPage.getFile();
        if (file != null) {
            try {
                this.importRules(file);
                this.m_wizardPage.storeFilename();
                return true;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RuleImportWizard_ERROR_IMPORT_DIALOG_TITLE, (String)MessageFormat.format(Messages.RuleImportWizard_ERROR_IMPORTING_FROM_FILE_X, file.toString()), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    private void showLog(List<TriggerRule> conflictingRules) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(Messages.RuleImportWizard_RULES_WITH_THESE_NAMES_COULD_NOT_IMPORT);
        for (TriggerRule r : conflictingRules) {
            messageBuilder.append(MessageFormat.format(RULE_CANT_BE_IMPORTED, r.getRulePath(), r.getName()));
            messageBuilder.append('\n');
        }
        DialogToolkit.showWarning((Shell)this.getShell(), (String)Messages.RuleImportWizard_WARNING_DIALOG_TITLE, (String)messageBuilder.toString());
    }

    private void importRules(File file) throws FileNotFoundException, IOException, SAXException {
        Element root = XmlToolkit.loadDocumentFromFile((File)file).getDocumentElement();
        List badRules = NotificationPlugin.getDefault().getNotificationRepository().importFromXML(root);
        if (!badRules.isEmpty()) {
            this.showLog(badRules);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(NotificationPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.RuleImportWizard_IMPORT_TIGGER_RULES_TITLE);
        this.m_wizardPage = new SimpleImportFromFileWizardPage(Messages.RuleImportWizard_WIZARD_NAME_IMPORT_RULES, "xml");
        this.m_wizardPage.setImageDescriptor(NotificationPlugin.getDefault().getMCImageDescriptor("new-trigger-wiz.gif"));
        this.m_wizardPage.setTitle(Messages.RuleImportWizard_WINDOW_TITLE_IMPORT_TRIGGER_RULES);
        this.m_wizardPage.setMessage(Messages.RuleImportWizard_WIZARD_MESSAGE_IMPORT_RULES);
        this.addPage((IWizardPage)this.m_wizardPage);
    }
}

