/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.tree.IParent;
import org.openjdk.jmc.ui.common.util.ICopyable;

public class Folder
implements IParent<Object>,
ICopyable,
IDescribable {
    private static final String[] EMPTY = new String[0];
    private static final Pattern PATH_SEP_PATTERN = Pattern.compile("\\/");
    private Folder parent;
    private String name;
    private final List<Object> leafs = new ArrayList<Object>();
    private final Map<String, Folder> sub = new HashMap<String, Folder>(5);

    public Folder(Folder parent, String name) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.sub.put(name, this);
        }
    }

    public void addLeaf(Object o) {
        this.leafs.add(o);
    }

    public void clearLeafs() {
        this.leafs.clear();
    }

    public Folder getFolder(String path) {
        return this.getFolder(this, path);
    }

    private Folder getFolder(Folder root, String path) {
        String[] stringArray = Folder.getSegments(path);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Folder sf = root.sub.get(segment);
            if (sf == null) {
                sf = new Folder(root, segment);
            }
            root = sf;
            ++n2;
        }
        return root;
    }

    private static String[] getSegments(String path) {
        return path == null ? EMPTY : PATH_SEP_PATTERN.split(path);
    }

    protected void setParent(Folder newParent) {
        if (newParent != this.parent) {
            if (newParent != null) {
                if (!newParent.isModifiable() || newParent.hasSubFolder(this.name) || newParent.isDescendentForm(this)) {
                    throw new IllegalStateException(String.valueOf(this) + " can't accept parent " + String.valueOf(newParent));
                }
                newParent.sub.put(this.name, this);
            }
            if (this.parent != null) {
                this.parent.sub.remove(this.name);
            }
            this.parent = newParent;
        }
    }

    public void dispose() {
        this.performInsert(this, null);
    }

    public void insert(Object o) {
        this.performInsert(o, this);
    }

    protected void performInsert(Object o, Folder into) {
        if (this.parent != null) {
            this.parent.performInsert(o, into);
        }
    }

    public void setName(String name) {
        if (!this.isModifiable()) {
            throw new IllegalStateException(String.valueOf(this) + " can't be changed");
        }
        this.parent.sub.remove(this.name);
        this.name = name;
        this.parent.sub.put(this.name, this);
        this.performInsert(this, this.parent);
    }

    public List<Object> getLeafs() {
        return this.leafs;
    }

    public Folder getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return null;
    }

    public void accept(Consumer<Folder> visitor) {
        try {
            visitor.accept(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Folder sf : this.sub.values()) {
            sf.accept(visitor);
        }
    }

    public boolean isModifiable() {
        return this.parent == null ? true : this.parent.isModifiable();
    }

    public boolean hasSubFolder(String subfolderName) {
        return this.sub.containsKey(subfolderName);
    }

    public boolean isDescendentForm(Folder node) {
        return this == node || this.parent != null && this.parent.isDescendentForm(node);
    }

    public String getPath(boolean omitRoot) {
        if (this.parent == null) {
            return omitRoot ? null : this.name;
        }
        return omitRoot && this.parent.parent == null ? this.name : this.parent.getPath(omitRoot) + "/" + this.name;
    }

    public boolean hasChildren() {
        return this.leafs.size() > 0 || this.sub.size() > 0;
    }

    public Collection<Object> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(this.leafs);
        children.addAll(this.sub.values());
        return children;
    }

    public String toString() {
        return this.getPath(false);
    }

    public boolean equals(Object obj) {
        return obj instanceof Folder && ((Folder)obj).getPath(false).equals(this.getPath(false));
    }

    public int hashCode() {
        return this.getPath(false).hashCode();
    }

    public boolean isCopyable() {
        for (Folder sf : this.sub.values()) {
            if (sf.isCopyable()) continue;
            return false;
        }
        for (Object l : this.leafs) {
            if (l instanceof ICopyable && ((ICopyable)l).isCopyable()) continue;
            return false;
        }
        return true;
    }

    public Folder copy() {
        return this.fillCopy(new Folder(null, this.name));
    }

    private Folder fillCopy(Folder parent) {
        for (Folder sf : this.sub.values()) {
            Folder sfCopy = sf.fillCopy(new Folder(parent, sf.name));
            parent.sub.put(sfCopy.name, sfCopy);
        }
        for (Object l : this.leafs) {
            if (!(l instanceof ICopyable)) continue;
            parent.leafs.add(((ICopyable)l).copy());
        }
        return parent;
    }
}

