/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.ui.views;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.greychart.GreyChart;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.Messages;

public class ExportChartAsImage
extends Action {
    private static final Rectangle RECT = new Rectangle(1920, 1080);
    private final GreyChart chart;

    public ExportChartAsImage(GreyChart chart) {
        super(Messages.EXPORT_AS_IMAGE_ACTION_TEXT);
        this.chart = chart;
    }

    public void run() {
        String fileName;
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.png"});
        while ((fileName = dialog.open()) != null) {
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                fileName = fileName.concat(".png");
            }
            File f = new File(fileName);
            Shell shell = Display.getCurrent().getActiveShell();
            if (f.exists() && !MessageDialog.openQuestion((Shell)shell, (String)Messages.DIALOG_FILE_EXISTS_TITLE, (String)NLS.bind((String)Messages.DIALOG_OVERWRITE_QUESTION_TEXT, (Object)fileName))) continue;
            BufferedImage imageAWT = new BufferedImage(ExportChartAsImage.RECT.width, ExportChartAsImage.RECT.height, 5);
            Graphics2D graphicsAWT = imageAWT.createGraphics();
            this.chart.render(graphicsAWT, RECT);
            try {
                ImageIO.write((RenderedImage)imageAWT, "png", f);
                break;
            }
            catch (IOException e) {
                DialogToolkit.showException((Shell)shell, (String)Messages.FAILED_TO_SAVE_IMAGE, (Throwable)e);
            }
        }
    }
}

