/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.uicomponents;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.console.ui.notification.uicomponents.FieldFocusListener;
import org.openjdk.jmc.console.ui.notification.uicomponents.InputItem;
import org.openjdk.jmc.rjmx.triggers.fields.internal.Field;
import org.openjdk.jmc.rjmx.triggers.fields.internal.PasswordField;
import org.openjdk.jmc.ui.uibuilder.IUIBuilder;

public class PasswordInputItem
extends InputItem
implements Field.FieldValueChangeListener {
    private Text m_password;

    public PasswordInputItem(PasswordField field, IUIBuilder builder) {
        super((Field)field, builder);
    }

    private Text getText() {
        return this.m_password;
    }

    @Override
    protected void create() {
        this.createUI();
        this.addListeners();
    }

    private void createUI() {
        this.getUIBuilder().createLabel(this.getField().getName() + ":", this.getField().getDescription());
        this.m_password = this.getUIBuilder().createText(this.getField().getPassword(), this.getField().getDescription(), 0x400000);
        this.getUIBuilder().layout();
    }

    private void addListeners() {
        this.getField().addFieldValueListener((Field.FieldValueChangeListener)this);
        this.getText().addFocusListener((FocusListener)new FieldFocusListener(this.getText(), this.getField()));
        this.getText().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PasswordInputItem.this.getField().removeFieldValueListener((Field.FieldValueChangeListener)PasswordInputItem.this);
            }
        });
        this.getText().addModifyListener(new ModifyListener(){
            private Color m_defaultColor = null;

            public void modifyText(ModifyEvent e) {
                if (this.m_defaultColor == null) {
                    this.m_defaultColor = PasswordInputItem.this.m_password.getForeground();
                }
                if (!PasswordInputItem.this.getField().validateValue(PasswordInputItem.this.m_password.getText())) {
                    PasswordInputItem.this.getText().setForeground(JFaceColors.getErrorText((Display)PasswordInputItem.this.getText().getDisplay()));
                } else {
                    PasswordInputItem.this.getText().setForeground(this.m_defaultColor);
                }
            }
        });
    }

    public void onChange(Field freshField) {
        if (freshField instanceof PasswordField) {
            this.getText().setText(this.getField().getPassword());
        } else {
            this.getText().setText(this.getField().getValue());
        }
    }
}

