/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.flightrecorder.ui.common.LaneEditor;
import org.openjdk.jmc.flightrecorder.ui.common.ThreadGraphLanes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;

public class DropdownLaneFilter
extends Composite {
    private static final int EXTRA_SHELL_WIDTH = 300;
    private static final int SHELL_HEIGHT = 500;
    private Button dropdownButton;
    private GridLayout layout;
    private MCContextMenuManager[] mms;
    private Shell shell;
    private ThreadGraphLanes lanes;
    private LaneEditor.EditLanesContainer container;

    public DropdownLaneFilter(Composite parent, final ThreadGraphLanes lanes, final MCContextMenuManager[] mms) {
        super(parent, 0);
        this.lanes = lanes;
        this.mms = mms;
        this.layout = new GridLayout();
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.setLayout((Layout)this.layout);
        this.dropdownButton = new Button((Composite)this, 2);
        this.dropdownButton.setLayoutData((Object)new GridData(1808));
        this.dropdownButton.setText(Messages.DropdownLaneFilter_THREAD_STATE_SELECTION);
        this.dropdownButton.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (Environment.getOSType() != Environment.OSType.LINUX) {
                    lanes.openEditLanesDialog(mms, false);
                    DropdownLaneFilter.this.dropdownButton.setSelection(false);
                } else if (DropdownLaneFilter.this.dropdownButton.getSelection()) {
                    DropdownLaneFilter.this.displayDropdown();
                }
            }
        });
    }

    private void displayDropdown() {
        Point p = this.dropdownButton.getParent().toDisplay(this.dropdownButton.getLocation());
        Point size = this.dropdownButton.getSize();
        Rectangle shellRect = new Rectangle(p.x, p.y + size.y, size.x, 0);
        this.shell = new Shell(this.getShell(), 2048);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                if (!DropdownLaneFilter.this.isCursorOnTopOfButton()) {
                    DropdownLaneFilter.this.dropdownButton.setSelection(false);
                }
                DropdownLaneFilter.this.disposeDropdown();
            }
        });
        this.shell.setLayout((Layout)this.layout);
        this.shell.setSize(shellRect.width + 300, 500);
        this.shell.setLocation(shellRect.x, shellRect.y);
        this.container = new LaneEditor.EditLanesContainer((Composite)this.shell, this.lanes.getTypeTree(), this.lanes.getLaneDefinitions(), () -> this.updateChart());
        this.container.setLayoutData(new GridData(1808));
        this.shell.open();
    }

    private void disposeDropdown() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
        }
    }

    private boolean isCursorOnTopOfButton() {
        Point cursor = Display.getCurrent().getCursorLocation();
        Point buttonLoc = this.dropdownButton.toDisplay(1, 1);
        Rectangle buttonRect = new Rectangle(buttonLoc.x, buttonLoc.y, this.dropdownButton.getSize().x, this.dropdownButton.getSize().y);
        return buttonRect.contains(cursor);
    }

    private void updateChart() {
        this.lanes.buildChart();
        this.lanes.updateContextMenus(this.mms, false);
    }
}

