/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.cpu;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class HighJvmCpuRule
implements IRule {
    private static final int MAX_SAMPLED_THREADS = 5;
    private static final String RESULT_ID = "HighJvmCpu";
    public static final TypedPreference<IQuantity> MISSING_SAMPLE_LIMIT = new TypedPreference("missing.sample.limit", Messages.getString("HighJvmCpuRule_CONFIG_SAMPLE_LIMIT"), Messages.getString("HighJvmCpuRule_CONFIG_SAMPLE_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    public static final TypedPreference<IQuantity> MINIMUM_CPU_LOAD_PERIOD = new TypedPreference("minimum.cpu.period", Messages.getString("HighJvmCpuRule_CONFIG_MIN_CPULOAD"), Messages.getString("HighJvmCpuRule_CONFIG_MIN_CPU_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(10L));
    public static final TypedPreference<IQuantity> JVM_CPU_INFO_LIMIT = new TypedPreference("jvm.cpu.info.limit", Messages.getString("HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT"), Messages.getString("HighJvmCpuRule_CONFIG_CPU_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(JVM_CPU_INFO_LIMIT, MINIMUM_CPU_LOAD_PERIOD, MISSING_SAMPLE_LIMIT);
    private static final IAggregator<IQuantity, ?> MAX_ENDTIME = Aggregators.max((String)Messages.getString("HighJvmCpuRule_AGGR_MAX_ENDTIME"), null, (String)"jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    private static final IAggregator<IQuantity, ?> MIN_ENDTIME = Aggregators.min((String)Messages.getString("HighJvmCpuRule_AGGR_MIN_ENDTIME"), null, (String)"jdk.CPULoad", (IAttribute)JfrAttributes.END_TIME);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.CPULoad", RulesToolkit.EventAvailability.AVAILABLE).build();
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        String periodNotBelow = RulesToolkit.getPeriodIfGreaterThan((IItemCollection)items, (IQuantity)((IQuantity)vp.getPreferenceValue(MINIMUM_CPU_LOAD_PERIOD)), (String[])new String[]{"jdk.CPULoad"});
        if (periodNotBelow != null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.INFO).setSummary(Messages.getString("HighJvmCpuRule_LONG_CPU_LOAD_PERIOD")).setExplanation(MessageFormat.format(Messages.getString("HighJvmCpuRule_LONG_CPU_LOAD_PERIOD_LONG"), periodNotBelow)).build();
        }
        IItemCollection cpuItems = items.apply(JdkFilters.CPU_LOAD);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_USER)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_USER, (IPreferenceValueProvider)vp);
        }
        IQuantity jvmUsage = (IQuantity)cpuItems.getAggregate(JdkAggregators.AVG_JVM_USER_CPU);
        IQuantity profilingSamples = (IQuantity)items.getAggregate(JdkAggregators.EXECUTION_SAMPLE_COUNT);
        IQuantity maxPeriodProfiling = RulesToolkit.getSettingMaxPeriod((IItemCollection)items, (String[])new String[]{"jdk.ExecutionSample"});
        if (profilingSamples != null && profilingSamples.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) > 0L && maxPeriodProfiling != null) {
            double missingSampleLimit;
            double jvmVal;
            double maximumSamplesPerSecond = UnitLookup.SECOND.quantity(1L).ratioTo(maxPeriodProfiling) * 5.0;
            IQuantity first = (IQuantity)cpuItems.getAggregate(MIN_ENDTIME);
            IQuantity last = (IQuantity)cpuItems.getAggregate(MAX_ENDTIME);
            double lengthInSeconds = last == null ? 0.0 : last.subtract(first).doubleValueIn((IUnit)UnitLookup.SECOND);
            double samples = profilingSamples.doubleValue();
            double samplesPerSecond = samples / lengthInSeconds;
            double lackingSamplesRatio = 1.0 - samplesPerSecond / maximumSamplesPerSecond;
            double lackingSamplesTimesCpu = lackingSamplesRatio * (jvmVal = jvmUsage.doubleValue());
            if (lackingSamplesTimesCpu >= (missingSampleLimit = ((IQuantity)vp.getPreferenceValue(MISSING_SAMPLE_LIMIT)).doubleValue())) {
                double missingSamplesScore = RulesToolkit.mapExp74((double)lackingSamplesTimesCpu, (double)missingSampleLimit);
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)missingSamplesScore)).setSummary(Messages.getString("HighJvmCpuRule_FEW_SAMPLES")).setExplanation(Messages.getString("HighJvmCpuRule_FEW_SAMPLES_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(missingSamplesScore)).build();
            }
        }
        long infoLimit = ((IQuantity)vp.getPreferenceValue(JVM_CPU_INFO_LIMIT)).longValue();
        double jvmUsageScore = RulesToolkit.mapExp74((double)jvmUsage.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)infoLimit);
        if (jvmUsageScore >= (double)infoLimit) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)jvmUsageScore)).setSummary(Messages.getString("HighJvmCpuRule_TEXT_WARN")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(jvmUsageScore)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("HighJvmCpuRule_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(jvmUsageScore)).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return HighJvmCpuRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HighJvmCpuRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

