/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.exceptions;

import java.util.Collections;
import java.util.Map;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FatalErrorRule
extends AbstractRule {
    private static final String RESULT_ID = "Fatal Errors";
    private static final String ERROR_REASON = "VM Error";
    private static final String INFO_REASON = "No remaining non-daemon Java threads";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.Shutdown", RulesToolkit.EventAvailability.AVAILABLE).build();

    public FatalErrorRule() {
        super(RESULT_ID, Messages.getString("FatalErrorRule_RULE_NAME"), "jvm_information", Collections.emptyList(), Collections.emptyList(), REQUIRED_EVENTS);
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemFilter shutdownFilter = ItemFilters.type((String)"jdk.Shutdown");
        IItemCollection shutdownItems = items.apply(shutdownFilter);
        if (shutdownItems.hasItems()) {
            if (shutdownItems.apply(ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.SHUTDOWN_REASON, (String)ERROR_REASON)).hasItems()) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("FatalErrorRule_TEXT_WARN")).build();
            }
            if (shutdownItems.apply(ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.SHUTDOWN_REASON, (String)INFO_REASON)).hasItems()) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("FatalErrorRule_TEXT_INFO")).build();
            }
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSummary(Messages.getString("FatalErrorRule_TEXT_OK")).build();
    }
}

