/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ClassLoadingRule
implements IRule {
    private static final String RESULT_ID = "ClassLoading";
    public static final TypedPreference<IQuantity> MAX_DURATION_LIMIT = new TypedPreference("classloading.duration.max.limit", Messages.getString("ClassLoadingRule_CONFIG_DURATION_LIMIT"), Messages.getString("ClassLoadingRule_CONFIG_DURATION_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(1000L));
    public static final TypedPreference<IQuantity> RATIO_OF_TOTAL_LIMIT = new TypedPreference("classloading.ratio-to-total.limit", Messages.getString("ClassLoadingRule_CONFIG_RATIO_LIMIT"), Messages.getString("ClassLoadingRule_CONFIG_RATIO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.1));
    public static final TypedResult<IQuantity> LONGEST_CLASS_LOAD = new TypedResult("longestClassLoad", Messages.getString("ClassLoadingRule_RESULT_LONGEST_LOAD_NAME"), Messages.getString("ClassLoadingRule_RESULT_LONGEST_LOAD_DESCRIPTION"), (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_CLASS_LOAD_TIME = new TypedResult("totalClassLoadTime", Messages.getString("ClassLoadingRule_RESULT_TOTAL_LOAD_TIME_NAME"), Messages.getString("ClassLoadingRule_RESULT_TOTAL_LOAD_TIME_DESCRIPTION"), (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_CLASS_LOAD_COUNT = new TypedResult("totalClassLoadCount", Messages.getString("ClassLoadingRule_RESULT_TOTAL_LOAD_COUNT_NAME"), Messages.getString("ClassLoadingRule_RESULT_TOTAL_LOAD_COUNT_DESCRIPTION"), (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(MAX_DURATION_LIMIT, RATIO_OF_TOTAL_LIMIT);
    private static final List<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_CLASS_LOAD, TOTAL_CLASS_LOAD_COUNT, TOTAL_CLASS_LOAD_TIME);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = new HashMap<String, RulesToolkit.EventAvailability>();

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ClassLoadingRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "classloading";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider dependencyResults) {
        IQuantity maxDurationLimit = (IQuantity)valueProvider.getPreferenceValue(MAX_DURATION_LIMIT);
        IQuantity ratioOfTotalLimit = (IQuantity)valueProvider.getPreferenceValue(RATIO_OF_TOTAL_LIMIT);
        IItemCollection events = items.apply(JdkFilters.CLASS_LOAD);
        IQuantity startTime = RulesToolkit.getEarliestStartTime((IItemCollection)events);
        IQuantity endTime = RulesToolkit.getLatestEndTime((IItemCollection)events);
        if (startTime != null && endTime != null) {
            IQuantity totalTime = endTime.subtract(startTime);
            IAggregator max = Aggregators.max((IAttribute)JfrAttributes.DURATION);
            IQuantity longestTime = (IQuantity)events.getAggregate(max);
            IQuantity sumTimeLoadedClasses = (IQuantity)events.getAggregate(Aggregators.sum((IAttribute)JfrAttributes.DURATION));
            if (longestTime.compareTo((Object)maxDurationLimit) > 0 || sumTimeLoadedClasses.ratioTo(totalTime) > ratioOfTotalLimit.doubleValue()) {
                IQuantity totalLoadedClasses = (IQuantity)events.getAggregate(Aggregators.count());
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).addResult(LONGEST_CLASS_LOAD, (Object)longestTime).addResult(TOTAL_CLASS_LOAD_COUNT, (Object)totalLoadedClasses).addResult(TOTAL_CLASS_LOAD_TIME, (Object)sumTimeLoadedClasses).addResult(TypedResult.ITEM_QUERY, (Object)JdkQueries.CLASS_LOAD).setSummary(Messages.getString("ClassLoadingRule_RESULT_SUMMARY")).setExplanation(Messages.getString("ClassLoadingRule_RESULT_EXPLANATION")).build();
            }
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("ClassLoadingRuleFactory_RULE_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, final IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ClassLoadingRule.this.getResult(items, preferenceValueProvider, dependencyResults);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    static {
        REQUIRED_EVENTS.put("jdk.ClassLoad", RulesToolkit.EventAvailability.ENABLED);
    }
}

