/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.SocketReadRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class SocketWriteRule
implements IRule {
    private static final String RESULT_ID = "SocketWrite";
    public static final TypedPreference<IQuantity> WRITE_INFO_LIMIT = new TypedPreference("io.socket.write.info.limit", Messages.getString("SocketWriteRule_CONFIG_INFO_LIMIT"), Messages.getString("SocketWriteRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(275L));
    public static final TypedPreference<IQuantity> WRITE_WARNING_LIMIT = new TypedPreference("io.socket.write.warning.limit", Messages.getString("SocketWriteRule_CONFIG_WARNING_LIMIT"), Messages.getString("SocketWriteRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WRITE_INFO_LIMIT, WRITE_WARNING_LIMIT);
    public static final TypedResult<IQuantity> LONGEST_WRITE_AMOUNT = new TypedResult("longestWriteAmount", "Longest Write (Amount)", "The amount read for the longest socket write.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> LONGEST_WRITE_TIME = new TypedResult("longestWriteTime", "Longest Write (Time)", "The longest time it took to perform a socket write.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<String> LONGEST_WRITE_ADDRESS = new TypedResult("longestWriteHost", "Longest Write (Host)", "The remote host of the socket write that took the longest time.", UnitLookup.PLAIN_TEXT, String.class);
    public static final TypedResult<IQuantity> LONGEST_TOTAL_READ = new TypedResult("totalWriteForLongest", "Total Write (Top Host)", "The total duration of all socket writes for the host with the longest write.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> AVERAGE_SOCKET_READ = new TypedResult("averageSocketWrite", "Average Socket Write", "The average duration of all socket writes.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_SOCKET_READ = new TypedResult("totalSocketWrite", "Total Socket Write", "The total duration of all socket writes.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_WRITE_ADDRESS, LONGEST_WRITE_AMOUNT, LONGEST_WRITE_TIME, LONGEST_TOTAL_READ, AVERAGE_SOCKET_READ, TOTAL_SOCKET_READ);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.SocketWrite", RulesToolkit.EventAvailability.AVAILABLE).build();

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider vp, final IResultValueProvider rp) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return SocketWriteRule.this.evaluate(items, vp, rp);
            }
        });
        return evaluationTask;
    }

    private IResult evaluate(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity infoLimit = (IQuantity)vp.getPreferenceValue(WRITE_INFO_LIMIT);
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(WRITE_WARNING_LIMIT);
        IItem longestEvent = (IItem)items.apply(JdkFilters.NO_RMI_SOCKET_WRITE).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        IItemCollection writeItems = items.apply(JdkFilters.NO_RMI_SOCKET_WRITE);
        if (longestEvent == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("SocketWriteRuleFactory_TEXT_NO_EVENTS")).setExplanation(Messages.getString("SocketWriteRuleFactory_TEXT_RMI_NOTE")).build();
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        Severity severity = Severity.get((double)score);
        if (severity == Severity.WARNING || severity == Severity.INFO) {
            String address = SocketReadRule.sanitizeAddress((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_ADDRESS));
            IQuantity amountWritten = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_SOCKET_BYTES_WRITTEN);
            IQuantity avgDuration = (IQuantity)writeItems.getAggregate(Aggregators.avg((String)"jdk.SocketWrite", (IAttribute)JfrAttributes.DURATION));
            IQuantity totalDuration = (IQuantity)writeItems.getAggregate(Aggregators.sum((String)"jdk.SocketWrite", (IAttribute)JfrAttributes.DURATION));
            IItemCollection eventsFromLongestAddress = writeItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.IO_ADDRESS, (Object)address));
            IQuantity totalLongestIOAddress = (IQuantity)eventsFromLongestAddress.getAggregate(Aggregators.sum((String)"jdk.SocketWrite", (IAttribute)JfrAttributes.DURATION));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("SocketWriteRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("SocketWriteRuleFactory_TEXT_WARN_LONG") + " " + Messages.getString("SocketWriteRuleFactory_TEXT_RMI_NOTE")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_WRITE_ADDRESS, (Object)address).addResult(LONGEST_WRITE_AMOUNT, (Object)amountWritten).addResult(LONGEST_TOTAL_READ, (Object)totalLongestIOAddress).addResult(AVERAGE_SOCKET_READ, (Object)avgDuration).addResult(TOTAL_SOCKET_READ, (Object)totalDuration).addResult(LONGEST_WRITE_TIME, (Object)maxDuration).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("SocketWriteRuleFactory_TEXT_OK")).setExplanation(Messages.getString("SocketWriteRuleFactory_TEXT_RMI_NOTE")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_WRITE_TIME, (Object)maxDuration).build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SocketWriteRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "socket_io";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

