/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;

final class SingleEntryItemCollection
implements IItemCollection {
    private static final IItemCollection NULLCOLLECTION = new IItemCollection(){

        public Iterator<IItemIterable> iterator() {
            return null;
        }

        public boolean hasItems() {
            return false;
        }

        public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
            return null;
        }

        public IItemCollection apply(IItemFilter filter) {
            return this;
        }

        public Set<IRange<IQuantity>> getUnfilteredTimeRanges() {
            return null;
        }
    };
    private static final IItemIterable NULLITERABLE = new IItemIterable(){

        public Iterator<IItem> iterator() {
            return null;
        }

        public IType<IItem> getType() {
            return null;
        }

        public boolean hasItems() {
            return false;
        }

        public long getItemCount() {
            return 0L;
        }

        public IItemIterable apply(Predicate<IItem> predicate) {
            return null;
        }
    };
    private final IItem item;
    private final Set<IRange<IQuantity>> chunkRanges;

    SingleEntryItemCollection(IItem item, Set<IRange<IQuantity>> chunkRanges) {
        this.item = item;
        this.chunkRanges = chunkRanges;
    }

    public Iterator<IItemIterable> iterator() {
        return new SingleEntryIteratorOfIterable(this.item);
    }

    public IItemCollection apply(IItemFilter filter) {
        return filter.getPredicate(this.item.getType()).test(this.item) ? this : NULLCOLLECTION;
    }

    public <V, C extends IItemConsumer<C>> V getAggregate(final IAggregator<V, C> aggregator) {
        return (V)aggregator.getValue((Object)new Iterator<C>(){
            boolean picked = false;

            @Override
            public boolean hasNext() {
                return !this.picked;
            }

            @Override
            public C next() {
                if (!this.picked) {
                    this.picked = true;
                    IItemConsumer calc = aggregator.newItemConsumer(SingleEntryItemCollection.this.item.getType());
                    calc.consume(SingleEntryItemCollection.this.item);
                    return calc;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean hasItems() {
        return true;
    }

    public Set<IRange<IQuantity>> getUnfilteredTimeRanges() {
        return this.chunkRanges;
    }

    private static class SingleEntryIteratorOfIterable
    implements Iterator<IItemIterable> {
        private final IItem item;
        private boolean picked = false;

        public SingleEntryIteratorOfIterable(IItem item) {
            this.item = item;
        }

        @Override
        public boolean hasNext() {
            return !this.picked;
        }

        @Override
        public IItemIterable next() {
            if (!this.picked) {
                this.picked = true;
                return new SingleEntryIItemIterable(this.item);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingleEntryIItemIterable
    implements IItemIterable {
        private final List<IItem> itemList = new ArrayList<IItem>(0);

        public SingleEntryIItemIterable(IItem item) {
            if (item == null) {
                throw new NullPointerException("Must have an item!");
            }
            this.itemList.add(item);
        }

        public Iterator<IItem> iterator() {
            return this.itemList.iterator();
        }

        public IType<IItem> getType() {
            return this.itemList.get(0).getType();
        }

        public boolean hasItems() {
            return false;
        }

        public long getItemCount() {
            return 1L;
        }

        public IItemIterable apply(Predicate<IItem> predicate) {
            if (predicate.test(this.itemList.get(0))) {
                return this;
            }
            return NULLITERABLE;
        }
    }
}

