/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.threads;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.console.ui.ConsolePlugin;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.threads.IThreadsModel;
import org.openjdk.jmc.console.ui.tabs.threads.StackTraceLabelProvider;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadModelException;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.ColumnsFilter;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.BackgroundFractionDrawer;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;
import org.openjdk.jmc.ui.polling.PollManager;
import org.openjdk.jmc.ui.polling.RefreshPollAction;

public class ThreadTableSectionPart
extends MCSectionPart
implements PollManager.Pollable,
IPersistable {
    private final DateFormat m_dateFormat = DateFormat.getTimeInstance(2);
    private final IThreadsModel m_threadsModel;
    private boolean m_informedMonitoredDeadlockedThreads;
    private final Button m_buttonCpuTiming;
    private final Button m_buttonDeadlockDetection;
    private final Button m_buttonAllocation;
    final ColumnManager columnManager;

    public ThreadTableSectionPart(Composite parent, FormToolkit toolkit, IThreadsModel threadsModel, IMemento state) {
        super(parent, toolkit, 384);
        this.getSection().setText(Messages.ThreadTableSectionPart_SECTION_TEXT);
        this.m_threadsModel = threadsModel;
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Composite topBar = toolkit.createComposite(body, 0);
        topBar.setLayoutData((Object)new GridData(4, 4, false, false));
        topBar.setLayout(MCLayoutFactory.createMarginFreeFormPageLayout((int)5));
        Table table = toolkit.createTable(body, 66306);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        viewer.setInput((Object)threadsModel);
        this.columnManager = ThreadTableSectionPart.createColumnManager(viewer, state);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)table));
        ColumnsFilter.addFilterControl((Composite)topBar, (FormToolkit)toolkit, (ColumnManager)this.columnManager);
        this.m_buttonCpuTiming = this.createTimingButton(topBar, toolkit);
        this.m_buttonDeadlockDetection = this.createDeadlockDetection(topBar, toolkit);
        this.m_buttonAllocation = this.createAllocation(topBar, toolkit);
        RefreshPollAction pollAction = new RefreshPollAction(Messages.ThreadTableSectionPart_REFRESH_STACK_TRACE, this.m_threadsModel.getPollManager(), (PollManager.Pollable)this);
        this.getMCToolBarManager().add((IAction)pollAction);
    }

    void addSelectionListener(ISelectionChangedListener listener) {
        this.columnManager.getViewer().addSelectionChangedListener(listener);
    }

    private static ColumnManager createColumnManager(TableViewer viewer, IMemento state) {
        IColumn name = new ColumnBuilder(Messages.THREAD_NAME_NAME_TEXT, "threadName", new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ThreadInfoCompositeSupport)element).getThreadName();
            }

            public Image getImage(Object element) {
                return StackTraceLabelProvider.getThreadImage((ThreadInfoCompositeSupport)element);
            }
        }).description(Messages.THREAD_NAME_DESCRIPTION_TEXT).build();
        IColumn cpuUsage = new ColumnBuilder(Messages.CPU_USAGE_NAME_TEXT, "cpuUsage", ThreadInfoCompositeSupport.GET_CPU_USAGE).description(Messages.CPU_USAGE_DESCRIPTION_TEXT).style(131072).columnDrawer(BackgroundFractionDrawer.unchecked(ThreadInfoCompositeSupport::getPartOfTimeRunning)).build();
        IColumn isDeadlocked = new ColumnBuilder(Messages.IS_DEADLOCKED_NAME_TEXT, "isDeadlocked", ThreadInfoCompositeSupport.IS_DEADLOCKED).description(Messages.IS_DEADLOCKED_DESCRIPTION_TEXT).build();
        IColumn alloc = new ColumnBuilder(Messages.ALLOCATED_MEMORY_NAME_TEXT, "allocatedMemory", ThreadInfoCompositeSupport.GET_ALLOCATED_BYTES).description(Messages.ALLOCATED_MEMORY_DESCRIPTION_TEXT).style(131072).build();
        IColumn blockedCount = new ColumnBuilder(Messages.BLOCKED_COUNT_NAME_TEXT, "blockedCount", ThreadInfoCompositeSupport.GET_BLOCKED_COUNT).description(Messages.BLOCKED_COUNT_DESCRIPTION_TEXT).style(131072).build();
        IColumn blockedTime = new ColumnBuilder(Messages.BLOCKED_TIME_NAME_TEXT, "blockedTime", ThreadInfoCompositeSupport.GET_BLOCKED_TIME).description(Messages.BLOCKED_TIME_DESCRIPTION_TEXT).style(131072).build();
        IColumn lockName = new ColumnBuilder(Messages.LOCK_NAME_NAME_TEXT, "lockName", ThreadInfoCompositeSupport.GET_LOCK_NAME).description(Messages.LOCK_NAME_DESCRIPTION_TEXT).build();
        IColumn lockOwnerId = new ColumnBuilder(Messages.LOCK_OWNER_ID_NAME_TEXT, "lockOwnerId", ThreadInfoCompositeSupport.GET_LOCK_OWNER_ID).description(Messages.LOCK_OWNER_ID_DESCRIPTION_TEXT).build();
        IColumn lockOwnerName = new ColumnBuilder(Messages.LOCK_OWNER_NAME_NAME_TEXT, "lockOwnerName", ThreadInfoCompositeSupport.GET_LOCK_OWNER_NAME).description(Messages.LOCK_OWNER_NAME_DESCRIPTION_TEXT).build();
        IColumn threadId = new ColumnBuilder(Messages.THREAD_ID_NAME_TEXT, "threadId", ThreadInfoCompositeSupport.GET_THREAD_ID).description(Messages.THREAD_ID_DESCRIPTION_TEXT).build();
        IColumn threadState = new ColumnBuilder(Messages.THREAD_STATE_NAME_TEXT, "threadState", ThreadInfoCompositeSupport.GET_THREAD_STATE).description(Messages.THREAD_STATE_DESCRIPTION_TEXT).build();
        IColumn waitCount = new ColumnBuilder(Messages.WAITED_COUNT_NAME_TEXT, "waitCount", ThreadInfoCompositeSupport.GET_WAITED_COUNT).description(Messages.WAITED_COUNT_DESCRIPTION_TEXT).style(131072).build();
        IColumn waitTime = new ColumnBuilder(Messages.WAITED_TIME_NAME_TEXT, "waitTime", ThreadInfoCompositeSupport.GET_WAITED_TIME).description(Messages.WAITED_TIME_DESCRIPTION_TEXT).style(131072).build();
        IColumn isInNative = new ColumnBuilder(Messages.IS_NATIVE_NAME_TEXT, "isInNative", ThreadInfoCompositeSupport.IS_IN_NATIVE).description(Messages.IS_NATIVE_DESCRIPTION_TEXT).build();
        IColumn isSuspended = new ColumnBuilder(Messages.IS_SUSPENDED_NAME_TEXT, "isSuspended", ThreadInfoCompositeSupport.IS_SUSPENDED).description(Messages.IS_SUSPENDED_DESCRIPTION_TEXT).build();
        IColumn isDaemon = new ColumnBuilder(Messages.IS_DAEMON_NAME_TEXT, "isDaemon", ThreadInfoCompositeSupport.IS_DAEMON).description(Messages.IS_DAEMON_DESCRIPTION_TEXT).build();
        List<IColumn> columns = Arrays.asList(name, blockedCount, blockedTime, lockName, lockOwnerId, lockOwnerName, threadId, threadState, waitCount, waitTime, isInNative, isSuspended, isDeadlocked, isDaemon, cpuUsage, alloc);
        return ColumnManager.build((TableViewer)viewer, columns, (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
    }

    private Button createTimingButton(Composite parent, FormToolkit toolkit) {
        final Button button = toolkit.createButton(parent, Messages.ThreadTableSectionPart_ENABLE_THREAD_CPU_PROFILING_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setCPUTimeEnabled(button.getSelection());
            }
        });
        return button;
    }

    private Button createDeadlockDetection(Composite parent, FormToolkit toolkit) {
        final Button button = toolkit.createButton(parent, Messages.ThreadTableSectionPart_ENABLE_DEADLOCK_DETECTION_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setDeadlockDetectionEnabled(button.getSelection());
            }
        });
        return button;
    }

    private Button createAllocation(Composite parent, FormToolkit toolkit) {
        final Button button = toolkit.createButton(parent, Messages.ThreadTableSectionPart_ENABLE_THREAD_ALLOCATION_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setAllocationEnabled(button.getSelection());
            }
        });
        return button;
    }

    public boolean poll() {
        try {
            try {
                this.m_threadsModel.update();
                DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Section section;
                        if (!ThreadTableSectionPart.this.m_threadsModel.isConnected()) {
                            ThreadTableSectionPart.this.m_threadsModel.getPollManager().stop();
                        }
                        if (!(section = ThreadTableSectionPart.this.getSection()).isDisposed()) {
                            ThreadTableSectionPart.this.columnManager.getViewer().refresh();
                            section.setDescription(NLS.bind((String)Messages.ThreadTableSectionPart_SECTION_DESCRIPTION_DATE, (Object)ThreadTableSectionPart.this.m_dateFormat.format(new Date())));
                        }
                        if (!ThreadTableSectionPart.this.m_informedMonitoredDeadlockedThreads && ThreadTableSectionPart.this.m_threadsModel.isUsingMonitoredThreadlockedThreads()) {
                            ThreadTableSectionPart.this.m_informedMonitoredDeadlockedThreads = true;
                            DialogToolkit.showWarningDialogAsync((Display)Display.getCurrent(), (String)Messages.ThreadTableSectionPart_USING_FIND_MONITORED_DEADLOCKED_THREADS_HEADER, (String)Messages.ThreadTableSectionPart_USING_FIND_MONITORED_DEADLOCKED_THREADS_TEXT);
                        }
                    }
                });
            }
            catch (ThreadModelException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not update the threads table!", e);
                this.updateButtonStatedFromModel();
                return false;
            }
        }
        finally {
            this.updateButtonStatedFromModel();
        }
        return true;
    }

    private void updateButtonStatedFromModel() {
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ThreadTableSectionPart.this.m_buttonCpuTiming.isDisposed()) {
                    ThreadTableSectionPart.this.m_buttonCpuTiming.setSelection(ThreadTableSectionPart.this.m_threadsModel.isCPUTimeEnabled());
                    ThreadTableSectionPart.this.m_buttonAllocation.setSelection(ThreadTableSectionPart.this.m_threadsModel.isAllocationEnabled());
                    ThreadTableSectionPart.this.m_buttonDeadlockDetection.setSelection(ThreadTableSectionPart.this.m_threadsModel.isDeadlockeDetectionEnabled());
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)memento));
    }
}

