/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import org.openjdk.jmc.common.xydata.DataSeries;
import org.openjdk.jmc.common.xydata.IXYData;
import org.openjdk.jmc.greychart.AbstractGreyChart;
import org.openjdk.jmc.greychart.AxisListener;
import org.openjdk.jmc.greychart.ChartChangeEvent;
import org.openjdk.jmc.greychart.FontAndColors;
import org.openjdk.jmc.greychart.XAxis;
import org.openjdk.jmc.greychart.XYGreyChart;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.data.DataSeriesProvider;
import org.openjdk.jmc.greychart.data.RenderingMode;
import org.openjdk.jmc.greychart.impl.CancelService;
import org.openjdk.jmc.greychart.impl.DefaultTitleRenderer;
import org.openjdk.jmc.greychart.impl.DefaultXAxis;
import org.openjdk.jmc.greychart.impl.DefaultXYLineRenderer;
import org.openjdk.jmc.greychart.impl.DefaultYAxis;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.providers.AveragingProvider;
import org.openjdk.jmc.greychart.providers.CompositeOptimizingProvider;
import org.openjdk.jmc.greychart.providers.IntermediateStackingProvider;
import org.openjdk.jmc.greychart.providers.SampleCountingProvider;
import org.openjdk.jmc.greychart.providers.SubsamplingProvider;
import org.openjdk.jmc.greychart.util.Messages;

public class DefaultXYGreyChart<XYData>
extends AbstractGreyChart<XYData>
implements XYGreyChart<XYData>,
AxisListener {
    private final ChartChangeEvent AXIS_CHANGE_EVENT = new ChartChangeEvent(this, ChartChangeEvent.ChangeType.OTHER_CHANGED);
    private XAxis m_xAxis;
    private YAxis[] m_yAxis;
    Rectangle m_titleRect = new Rectangle();
    Rectangle m_xAxisRect = new Rectangle();
    Rectangle m_plotRect = new Rectangle();
    Rectangle m_indexRect = new Rectangle();
    private OptimizingProvider m_optimizingProvider;
    private OptimizingProvider m_leftYAxisProvider;
    private OptimizingProvider m_rightYAxisProvider;
    private boolean m_isAutoUpdateOnAxisChange = true;
    private int m_oldResolution = 0;
    private final CancelService m_cancelService = new CancelService();

    public DefaultXYGreyChart() {
        super(Messages.getString("DefaultXYGreyChart_DEFAULT_TITLE"));
        this.m_xAxis = new DefaultXAxis(this);
        this.m_yAxis = new DefaultYAxis[0];
        this.setPlotRenderer(new DefaultXYLineRenderer(this));
        this.m_titleRenderer = new DefaultTitleRenderer(this);
        this.setBackground(FontAndColors.getDefaultBackground());
    }

    @Override
    public DefaultXYLineRenderer getPlotRenderer() {
        return (DefaultXYLineRenderer)super.getPlotRenderer();
    }

    @Override
    public void setXAxis(XAxis axis) {
        this.m_xAxis = axis;
        this.rebuildOptimizingProvider(this.getDataProvider());
        this.updateAxisListeners();
    }

    @Override
    public XAxis getXAxis() {
        return this.m_xAxis;
    }

    @Override
    public void addYAxis(YAxis axis) {
        this.addToYAxisArray(axis);
        this.updateAxisListeners();
    }

    private void addToYAxisArray(YAxis axis) {
        ArrayList<YAxis> list = new ArrayList<YAxis>(Arrays.asList(this.m_yAxis));
        list.add(axis);
        this.m_yAxis = list.toArray(new YAxis[list.size()]);
    }

    @Override
    public YAxis[] getYAxis() {
        return this.m_yAxis;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle where) {
        if (this.m_oldResolution == 0) {
            this.m_oldResolution = (int)Math.round(where.getWidth());
        }
        if (this.hasDataProvider() && this.m_optimizingProvider != null) {
            this.m_optimizingProvider.setResolution(this.m_oldResolution);
            this.m_optimizingProvider.setRange(this.getXAxis().getMin().longValue(), this.getXAxis().getMax().longValue());
            this.m_optimizingProvider.update();
        }
        Shape oldClip = ctx.getClip();
        ctx.setFont(FontAndColors.getDefaultFont());
        Rectangle allMinusIndex = new Rectangle(where);
        int index_w = this.getIndexRenderer() == null ? 0 : this.getIndexRenderer().getPreferredDimensions((Graphics2D)ctx, (Rectangle)where).width;
        allMinusIndex.width -= index_w;
        YAxisData[] dataArray = this.createYAxisData(this.m_yAxis, ctx, allMinusIndex);
        int title_h = this.getTitleRenderer() == null ? 0 : this.getTitleRenderer().getPreferredDimensions((Graphics2D)ctx, (Rectangle)where).height;
        int xaxis_h = this.getXAxis().getPreferredDimensions((Graphics2D)ctx, (Rectangle)where).height;
        int plot_h = Math.max(where.height - xaxis_h - title_h, 0);
        int total_left = this.sum(dataArray, YAxis.Position.LEFT);
        int total_right = this.sum(dataArray, YAxis.Position.RIGHT);
        int plot_w = Math.max(where.width - index_w - total_left - total_right, 0);
        if (this.hasDataProvider() && this.m_optimizingProvider != null && this.m_oldResolution != plot_w) {
            this.m_optimizingProvider.setResolution(plot_w);
            this.m_oldResolution = plot_w;
            this.m_optimizingProvider.update();
        }
        ctx.setClip(where);
        ctx.setColor(this.getBackground());
        ctx.fillRect(where.x, where.y, where.width, where.height);
        if (this.isAntaliasingEnabled()) {
            ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (title_h > 0) {
            this.m_titleRect.x = where.x;
            this.m_titleRect.width = where.width;
            this.m_titleRect.y = where.y;
            this.m_titleRect.height = title_h;
            this.getTitleRenderer().render(ctx, this.m_titleRect, where);
        }
        int yaxisY = this.m_titleRect.y + this.m_titleRect.height;
        this.m_xAxisRect.x = total_left;
        this.m_xAxisRect.width = plot_w;
        this.m_xAxisRect.y = yaxisY + plot_h;
        this.m_xAxisRect.height = xaxis_h;
        this.m_plotRect.x = this.m_xAxisRect.x;
        this.m_plotRect.y = yaxisY;
        this.m_plotRect.width = plot_w;
        this.m_plotRect.height = plot_h;
        if (index_w > 0) {
            --this.m_plotRect.width;
            --this.m_xAxisRect.width;
            this.m_indexRect.x = this.m_xAxisRect.x + this.m_xAxisRect.width + 1 + total_right;
            this.m_indexRect.y = this.m_plotRect.y;
            this.m_indexRect.height = plot_h;
            this.m_indexRect.width = index_w;
            this.getIndexRenderer().render(ctx, this.m_indexRect, where);
        }
        this.getPlotRenderer().clear(ctx, this.m_plotRect);
        YAxis[] yAxisArray = this.getYAxis();
        int n = yAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            y.render(ctx, this.caculateYRect(y, this.m_plotRect, dataArray), this.m_plotRect);
            ++n2;
        }
        this.getXAxis().render(ctx, this.m_xAxisRect, this.m_plotRect);
        if (this.m_optimizingProvider != null) {
            this.getPlotRenderer().render(ctx, this.m_plotRect, where);
        }
        ctx.setClip(oldClip);
    }

    private Rectangle caculateYRect(YAxis y, Rectangle mPlotRect, YAxisData[] dataArray) {
        YAxisData data;
        int n;
        int n2;
        YAxisData[] yAxisDataArray;
        int startX = 0;
        int myWidth = 0;
        if (y.getPosition() == YAxis.Position.RIGHT) {
            startX += mPlotRect.width;
            yAxisDataArray = dataArray;
            n2 = dataArray.length;
            n = 0;
            while (n < n2) {
                data = yAxisDataArray[n];
                if (data.axis.getPosition() == YAxis.Position.LEFT) {
                    startX += data.width;
                }
                ++n;
            }
        }
        yAxisDataArray = dataArray;
        n2 = dataArray.length;
        n = 0;
        while (n < n2) {
            data = yAxisDataArray[n];
            if (data.axis == y) {
                myWidth = data.width;
                break;
            }
            if (data.axis.getPosition() == y.getPosition()) {
                startX += data.width;
            }
            ++n;
        }
        return new Rectangle(startX, mPlotRect.y, myWidth, mPlotRect.height);
    }

    private int sum(YAxisData[] dataArray, YAxis.Position pos) {
        int sum = 0;
        YAxisData[] yAxisDataArray = dataArray;
        int n = dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            YAxisData data = yAxisDataArray[n2];
            if (data.axis.getPosition() == pos) {
                sum += data.width;
            }
            ++n2;
        }
        return sum;
    }

    private YAxisData[] createYAxisData(YAxis[] yAxis, Graphics2D ctx, Rectangle totalDrawingArea) {
        YAxisData[] data = new YAxisData[yAxis.length];
        int i = 0;
        while (i < data.length) {
            data[i] = new YAxisData();
            data[i].axis = yAxis[i];
            Dimension dim = yAxis[i].getPreferredDimensions(ctx, totalDrawingArea);
            data[i].width = dim.width;
            ++i;
        }
        return data;
    }

    private boolean hasDataProvider() {
        return this.getDataProvider() != null;
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        this.getPlotRenderer().setBackground(bgColor);
        this.getXAxis().setBackground(bgColor);
        if (this.getLastYAxis() != null) {
            this.getLastYAxis().setBackground(bgColor);
        }
        if (this.getIndexRenderer() != null) {
            this.getIndexRenderer().setBackground(bgColor);
        }
        if (this.getTitleRenderer() != null) {
            this.getTitleRenderer().setBackground(bgColor);
        }
        int r = (bgColor.getRed() + this.getForeground().getRed()) / 2;
        int g = (bgColor.getGreen() + this.getForeground().getGreen()) / 2;
        int b = (bgColor.getBlue() + this.getForeground().getBlue()) / 2;
        Color titleColor = new Color(r, g, b);
        this.setAxisTitleColor(titleColor);
    }

    private YAxis getLastYAxis() {
        if (this.m_yAxis.length == 0) {
            return null;
        }
        return this.m_yAxis[this.m_yAxis.length - 1];
    }

    @Override
    public void setForeground(Color fgColor) {
        super.setForeground(fgColor);
        this.getPlotRenderer().setForeground(fgColor);
        this.getXAxis().setForeground(fgColor);
        YAxis[] yAxisArray = this.getYAxis();
        int n = yAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis yAxis = yAxisArray[n2];
            yAxis.setForeground(fgColor);
            ++n2;
        }
        if (this.getIndexRenderer() != null) {
            this.getIndexRenderer().setForeground(fgColor);
        }
        if (this.getTitleRenderer() != null) {
            this.getTitleRenderer().setForeground(fgColor);
        }
        int r = (fgColor.getRed() + this.getBackground().getRed()) / 2;
        int g = (fgColor.getGreen() + this.getBackground().getGreen()) / 2;
        int b = (fgColor.getBlue() + this.getBackground().getBlue()) / 2;
        Color titleColor = new Color(r, g, b);
        this.setAxisTitleColor(titleColor);
    }

    public void setAxisTitleColor(Color titleColor) {
        this.getXAxis().setTitleColor(titleColor);
        YAxis[] yAxisArray = this.getYAxis();
        int n = yAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis yAxis = yAxisArray[n2];
            yAxis.setTitleColor(titleColor);
            ++n2;
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Override
    public void setDataProvider(DataSeriesProvider<XYData> dataProvider) {
        this.rebuildOptimizingProvider(dataProvider);
        super.setDataProvider(dataProvider);
    }

    private void rebuildOptimizingProvider(DataSeriesProvider<XYData> sp) {
        if (sp == null) {
            return;
        }
        DataSeries<XYData>[] series = sp.getDataSeries();
        OptimizingProvider[] optimizingProviders = new OptimizingProvider[series.length];
        OptimizingProvider[][] stacks = new OptimizingProvider[series.length][0];
        int n = 0;
        while (n < series.length) {
            OptimizingProvider provider = this.createOptimizingProvider(series[n], this.getMetadataProvider().getMultiplier(series[n]), this.getMetadataProvider().getMode(series[n]));
            if (this.getMetadataProvider().getStacking(series[n])) {
                this.stackProvider(provider, stacks, n, series.length);
            }
            optimizingProviders[n] = provider;
            ++n;
        }
        if (series.length == 0) {
            this.m_optimizingProvider = null;
            this.m_leftYAxisProvider = null;
            this.m_rightYAxisProvider = null;
        } else {
            this.buildStacks(series, optimizingProviders, stacks);
            this.buildLeftAndRightProviders(series, optimizingProviders);
            this.m_optimizingProvider = new CompositeOptimizingProvider(optimizingProviders);
        }
    }

    private OptimizingProvider createOptimizingProvider(DataSeries series, double yMultiplier, RenderingMode mode) {
        boolean integrating = mode == RenderingMode.DENSITY_INTEGRATING || mode == RenderingMode.INTEGRATING;
        switch (mode) {
            case DENSITY: 
            case DENSITY_INTEGRATING: {
                return new SampleCountingProvider((DataSeries<IXYData>)series, yMultiplier, this.getXAxis(), this.m_cancelService, integrating);
            }
            case AVERAGING: {
                return new AveragingProvider((DataSeries<IXYData>)series, yMultiplier, this.getXAxis(), this.m_cancelService);
            }
        }
        return new SubsamplingProvider((DataSeries<IXYData>)series, yMultiplier, this.getXAxis(), this.m_cancelService, integrating);
    }

    private void buildStacks(DataSeries[] series, OptimizingProvider[] optimizingProviders, OptimizingProvider[][] stacks) {
        int n = 0;
        while (n < series.length) {
            if (stacks[n].length > 0) {
                optimizingProviders[n] = new IntermediateStackingProvider(stacks[n][0], stacks[n]);
            }
            ++n;
        }
    }

    private void buildLeftAndRightProviders(DataSeries[] series, OptimizingProvider[] optimizingProviders) {
        ArrayList<OptimizingProvider> leftAxisProviders = new ArrayList<OptimizingProvider>();
        ArrayList<OptimizingProvider> rightAxisProviders = new ArrayList<OptimizingProvider>();
        int n = 0;
        while (n < series.length) {
            YAxis yAxis = this.getMetadataProvider().getYAxis(series[n]);
            if (yAxis != null && yAxis.getPosition() == YAxis.Position.RIGHT) {
                rightAxisProviders.add(optimizingProviders[n]);
            } else {
                leftAxisProviders.add(optimizingProviders[n]);
            }
            ++n;
        }
        this.m_leftYAxisProvider = new CompositeOptimizingProvider(leftAxisProviders.toArray(new OptimizingProvider[leftAxisProviders.size()]));
        this.m_rightYAxisProvider = new CompositeOptimizingProvider(rightAxisProviders.toArray(new OptimizingProvider[rightAxisProviders.size()]));
    }

    private void stackProvider(OptimizingProvider provider, OptimizingProvider[][] stacks, int n, int maxLength) {
        stacks[n] = new OptimizingProvider[maxLength];
        stacks[n][0] = provider;
        int m = 0;
        while (m < n) {
            if (stacks[m].length > 0) {
                stacks[m][n] = stacks[n][0];
            }
            ++m;
        }
    }

    public OptimizingProvider getOptimizingProvider() {
        return this.m_optimizingProvider;
    }

    public boolean isAutoUpdateOnAxisChange() {
        return this.m_isAutoUpdateOnAxisChange;
    }

    public void setAutoUpdateOnAxisChange(boolean enable) {
        this.m_isAutoUpdateOnAxisChange = enable;
        this.updateAxisListeners();
    }

    private void updateAxisListeners() {
        if (this.isAutoUpdateOnAxisChange()) {
            this.getXAxis().addAxisListener(this);
            YAxis[] yAxisArray = this.getYAxis();
            int n = yAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                YAxis yAxis = yAxisArray[n2];
                yAxis.addAxisListener(this);
                ++n2;
            }
        } else {
            this.getXAxis().removeAxisListener(this);
            YAxis[] yAxisArray = this.getYAxis();
            int n = yAxisArray.length;
            int n3 = 0;
            while (n3 < n) {
                YAxis yAxis = yAxisArray[n3];
                yAxis.removeAxisListener(this);
                ++n3;
            }
        }
    }

    @Override
    public void onAxisChanged() {
        this.fireChangeEvent(this.AXIS_CHANGE_EVENT);
    }

    public OptimizingProvider getYAxisProvider(YAxis.Position position) {
        if (position == YAxis.Position.RIGHT) {
            return this.m_rightYAxisProvider;
        }
        return this.m_leftYAxisProvider;
    }

    public void abort() {
        this.m_cancelService.cancel();
    }

    private static class YAxisData {
        YAxis axis;
        int width;

        private YAxisData() {
        }
    }
}

