/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.providers.AbstractSampler;

public class SampleCountingBuffer
extends AbstractSampler {
    public SampleCountingBuffer(int size) {
        super(size);
        int n = 0;
        while (n < this.getSize()) {
            this.getSamplePoint(n);
            ++n;
        }
    }

    public void addDataPoint(double normalizedX, double currentY) {
        if (normalizedX < 0.0 || normalizedX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedX);
        }
        this.addSamplePoint((double)this.getSize() * normalizedX, currentY);
    }

    private void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.getSize()) {
            SamplePoint sp = this.getSamplePoint(currentIndex);
            ++sp.count;
            sp.y += 1.0;
            this.invalidateStatistics();
        }
    }
}

