/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.remoteagent;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.browser.attach.LocalJVMToolkit;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.internal.ServerToolkit;

public class RemoteJMXAgentSettings {
    private static final String HELP_CMD = "help";
    private static final String MANAGEMENT_AGENT_STATUS_CMD = "ManagementAgent.status";

    public static Properties getCurrentAgentSettings(IServerHandle serverHandle) {
        Properties p = new Properties();
        String pid = String.valueOf(ServerToolkit.getPid((IServerHandle)serverHandle));
        try {
            String result = LocalJVMToolkit.executeCommandForPid((String)pid, (String)HELP_CMD);
            if (result.contains(MANAGEMENT_AGENT_STATUS_CMD)) {
                result = LocalJVMToolkit.executeCommandForPid((String)pid, (String)MANAGEMENT_AGENT_STATUS_CMD);
                Matcher matcher = Pattern.compile("(Connection Type\\s*:\\s*remote.*\\n\\n)", 32).matcher(result);
                if (matcher.find()) {
                    String agentGroup = matcher.group();
                    p.putAll((Map<?, ?>)RemoteJMXAgentSettings.parseAgentSettings(agentGroup));
                }
                return p;
            }
        }
        catch (AgentLoadException | AttachNotSupportedException | IOException | IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException exception) {}
        return null;
    }

    private static Properties parseAgentSettings(String agentStatusOutput) {
        Properties p = new Properties();
        Pattern propertiesPattern = Pattern.compile("com\\.sun\\.management\\..*=");
        String ls = "\n";
        String[] lines = agentStatusOutput.split(ls);
        p.putAll(Stream.of(lines).filter(s -> propertiesPattern.matcher((CharSequence)s).find()).map(RemoteJMXAgentSettings::removePrefixToMatchJcmdSettings).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0].trim(), RemoteJMXAgentSettings::getSettingsValue)));
        return p;
    }

    private static String removePrefixToMatchJcmdSettings(String s) {
        return s.replace("com.sun.management.", "");
    }

    private static Object getSettingsValue(String[] s) {
        String valueString = s[1].replaceAll("\\[default\\]", "").trim();
        if (Boolean.TRUE.toString().equalsIgnoreCase(valueString) || Boolean.FALSE.toString().equalsIgnoreCase(valueString)) {
            return Boolean.valueOf(valueString);
        }
        return valueString;
    }
}

