/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.commands;

import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.openjdk.jmc.commands.Command;
import org.openjdk.jmc.commands.CommandFactory;
import org.openjdk.jmc.commands.Statement;
import org.openjdk.jmc.commands.Tokenizer;
import org.openjdk.jmc.commands.internal.parser.TextParser;
import org.osgi.framework.BundleContext;

public final class CommandsPlugin
extends Plugin {
    private static CommandsPlugin s_plugin;
    private List<Command> m_commands;
    private TextParser m_textParser;
    private final Map<String, Object> m_map = new HashMap<String, Object>();

    public CommandsPlugin() {
        s_plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        s_plugin = this;
        this.m_commands = CommandFactory.createFromExtensionPoints();
        this.m_textParser = new TextParser(this.m_commands);
    }

    public void stop(BundleContext context) throws Exception {
        s_plugin = null;
        super.stop(context);
    }

    public static CommandsPlugin getDefault() {
        return s_plugin;
    }

    public List<Statement> parse(String text) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(text);
        return this.m_textParser.parse(tokenizer);
    }

    public void execute(String text, PrintStream output) throws ParseException {
        this.execute(this.parse(text), output);
    }

    public void execute(List<Statement> statements, PrintStream output) {
        for (Statement c : statements) {
            this.execute(c, output);
        }
    }

    public void execute(Statement statement, PrintStream output) {
        statement.execute(output);
    }

    public Command getCommand(String name) {
        for (Command c : this.getCommands()) {
            if (!name.equals(c.getIdentifier())) continue;
            return c;
        }
        return null;
    }

    public List<Command> getCommands() {
        return this.m_commands;
    }

    public List<String> getCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (Command c : this.getCommands()) {
            categories.add(c.getCategory());
        }
        ArrayList<String> list = new ArrayList<String>(categories);
        list.sort(null);
        return list;
    }

    public List<Command> getCommands(String category) {
        ArrayList<Command> list = new ArrayList<Command>();
        for (Command c : this.getCommands()) {
            if (!category.equals(c.getCategory())) continue;
            list.add(c);
        }
        list.sort(null);
        return list;
    }

    public Object getEnvironmentVariable(String key) {
        return this.m_map.get(key);
    }

    public Object putEnvironmentVariable(String key, Object value) {
        return this.m_map.put(key, value);
    }
}

