/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.parser;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;

class MappedReadBuffer
extends ReadBuffer {
    private final MappedByteBuffer buf;

    MappedReadBuffer(MappedByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public synchronized void get(long pos, byte[] res) throws IOException {
        this.seek(pos);
        this.buf.get(res);
    }

    @Override
    public synchronized void get(long pos, byte[] res, int num) throws IOException {
        this.seek(pos);
        this.buf.get(res, 0, num);
    }

    @Override
    public synchronized int getInt(long pos) throws IOException {
        this.seek(pos);
        return this.buf.getInt();
    }

    @Override
    public synchronized long getLong(long pos) throws IOException {
        this.seek(pos);
        return this.buf.getLong();
    }

    private void seek(long pos) throws IOException {
        assert (pos <= Integer.MAX_VALUE) : "position overflow";
        this.buf.position((int)pos);
    }

    @Override
    public void close() {
    }
}

