/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartConfig;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.Invocable;

public class DelayedHandler
extends Handler.Wrapper {
    public DelayedHandler() {
        this((Handler)null);
    }

    public DelayedHandler(Handler handler) {
        super(handler);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        MimeTypes.Type mimeType;
        DelayedProcess delayed;
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        boolean contentExpected = false;
        String contentType = null;
        block6: for (HttpField field : request.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_TYPE: {
                    contentType = field.getValue();
                    break;
                }
                case CONTENT_LENGTH: {
                    contentExpected = field.getLongValue() > 0L;
                    break;
                }
                case TRANSFER_ENCODING: {
                    contentExpected = field.contains(HttpHeaderValue.CHUNKED.asString());
                    break;
                }
                case EXPECT: {
                    if (!field.contains(HttpHeaderValue.CONTINUE.asString())) break;
                    contentExpected = false;
                    break block6;
                }
            }
        }
        if ((delayed = this.newDelayedProcess(contentExpected, contentType, mimeType = MimeTypes.getBaseType(contentType), next, request, response, callback)) == null) {
            return next.handle(request, response, callback);
        }
        delayed.delay();
        return true;
    }

    protected DelayedProcess newDelayedProcess(boolean contentExpected, String contentType, MimeTypes.Type mimeType, Handler handler, Request request, Response response, Callback callback) {
        if (!contentExpected) {
            return null;
        }
        if (!request.getConnectionMetaData().getHttpConfiguration().isDelayDispatchUntilContent()) {
            return null;
        }
        if (mimeType == null) {
            return new UntilContentDelayedProcess(handler, request, response, callback);
        }
        return switch (mimeType) {
            case MimeTypes.Type.FORM_ENCODED -> new UntilFormDelayedProcess(handler, request, response, callback, contentType);
            case MimeTypes.Type.MULTIPART_FORM_DATA -> {
                Object var9_8 = request.getContext().getAttribute(MultiPartConfig.class.getName());
                if (var9_8 instanceof MultiPartConfig) {
                    MultiPartConfig mpc = (MultiPartConfig)var9_8;
                    yield new UntilMultipartDelayedProcess(handler, request, response, callback, contentType, mpc);
                }
                var9_8 = this.getServer().getAttribute(MultiPartConfig.class.getName());
                if (var9_8 instanceof MultiPartConfig) {
                    MultiPartConfig mpc = (MultiPartConfig)var9_8;
                    yield new UntilMultipartDelayedProcess(handler, request, response, callback, contentType, mpc);
                }
                yield null;
            }
            default -> new UntilContentDelayedProcess(handler, request, response, callback);
        };
    }

    protected static abstract class DelayedProcess {
        private final Handler _handler;
        private final Request _request;
        private final Response _response;
        private final Callback _callback;

        protected DelayedProcess(Handler handler, Request request, Response response, Callback callback) {
            this._handler = Objects.requireNonNull(handler);
            this._request = Objects.requireNonNull(request);
            this._response = Objects.requireNonNull(response);
            this._callback = Objects.requireNonNull(callback);
        }

        protected Handler getHandler() {
            return this._handler;
        }

        protected Request getRequest() {
            return this._request;
        }

        protected Response getResponse() {
            return this._response;
        }

        protected Callback getCallback() {
            return this._callback;
        }

        protected void process() {
            try {
                if (!this.getHandler().handle(this.getRequest(), this.getResponse(), this.getCallback())) {
                    Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), 404);
                }
            }
            catch (Throwable t) {
                Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), t);
            }
        }

        protected abstract void delay() throws Exception;
    }

    protected static class UntilContentDelayedProcess
    extends DelayedProcess {
        public UntilContentDelayedProcess(Handler handler, Request request, Response response, Callback callback) {
            super(handler, request, response, callback);
        }

        @Override
        protected void delay() {
            Content.Chunk chunk = super.getRequest().read();
            if (chunk == null) {
                this.getRequest().demand((Runnable)Invocable.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, this::onContent));
            } else {
                RewindChunkRequest request = new RewindChunkRequest(this.getRequest(), chunk);
                try {
                    this.getHandler().handle(request, this.getResponse(), this.getCallback());
                }
                catch (Throwable x) {
                    Response.writeError((Request)request, this.getResponse(), this.getCallback(), x);
                }
            }
        }

        public void onContent() {
            this.getRequest().getContext().execute(this::process);
        }

        private static class RewindChunkRequest
        extends Request.Wrapper {
            private final AtomicReference<Content.Chunk> _chunk;

            public RewindChunkRequest(Request wrapped, Content.Chunk chunk) {
                super(wrapped);
                this._chunk = new AtomicReference<Content.Chunk>(chunk);
            }

            @Override
            public Content.Chunk read() {
                Content.Chunk chunk = this._chunk.getAndSet(null);
                if (chunk != null) {
                    return chunk;
                }
                return super.read();
            }
        }
    }

    protected static class UntilFormDelayedProcess
    extends DelayedProcess {
        private final Charset _charset;

        public UntilFormDelayedProcess(Handler handler, Request wrapped, Response response, Callback callback, String contentType) {
            super(handler, wrapped, response, callback);
            String cs = MimeTypes.getCharsetFromContentType((String)contentType);
            this._charset = StringUtil.isEmpty((String)cs) ? StandardCharsets.UTF_8 : Charset.forName(cs);
        }

        @Override
        protected void delay() {
            final Invocable.InvocationType invocationType = this.getHandler().getInvocationType();
            final AtomicInteger done = new AtomicInteger(2);
            Promise.Invocable<Fields> onFields = new Promise.Invocable<Fields>(){

                public void failed(Throwable x) {
                    Response.writeError(this.getRequest(), this.getResponse(), this.getCallback(), x);
                }

                public void succeeded(Fields result) {
                    if (done.decrementAndGet() == 0) {
                        invocationType.runWithoutBlocking(this::doProcess, (Executor)this.getRequest().getContext());
                    }
                }

                private void doProcess() {
                    this.process();
                }

                public Invocable.InvocationType getInvocationType() {
                    return invocationType;
                }
            };
            FormFields.onFields(this.getRequest(), this._charset, onFields);
            if (done.decrementAndGet() == 0) {
                this.process();
            }
        }
    }

    protected static class UntilMultipartDelayedProcess
    extends DelayedProcess {
        private final String _contentType;
        private final MultiPartConfig _config;

        public UntilMultipartDelayedProcess(Handler handler, Request request, Response response, Callback callback, String contentType, MultiPartConfig config) {
            super(handler, request, response, callback);
            this._contentType = contentType;
            this._config = config;
        }

        @Override
        protected void delay() {
            Request request = this.getRequest();
            final Invocable.InvocationType invocationType = this.getHandler().getInvocationType();
            final AtomicInteger done = new AtomicInteger(2);
            Promise.Invocable<MultiPartFormData.Parts> onParts = new Promise.Invocable<MultiPartFormData.Parts>(){

                public void failed(Throwable x) {
                    this.succeeded(null);
                }

                public void succeeded(MultiPartFormData.Parts result) {
                    if (done.decrementAndGet() == 0) {
                        invocationType.runWithoutBlocking(this::doProcess, (Executor)this.getRequest().getContext());
                    }
                }

                private void doProcess() {
                    this.process();
                }

                public Invocable.InvocationType getInvocationType() {
                    return invocationType;
                }
            };
            MultiPartFormData.onParts((Content.Source)request, (Attributes)request, (String)this._contentType, (MultiPartConfig)this._config, (Promise.Invocable)onParts);
            if (done.decrementAndGet() == 0) {
                this.process();
            }
        }
    }
}

