/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.ui.AttributeConfiguration;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;

public class BasicConfig
implements IStateful {
    public static final String STATE_ID = "config-attribute";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String VALUE_ATTRIBUTE = "value";
    private final Map<String, ValueEntry<?>> entries = new HashMap();
    private Map<String, Collection<IRule>> prefRuleMap = new HashMap<String, Collection<IRule>>();

    public BasicConfig(IState state) {
        Collection rules = RuleRegistry.getRules();
        for (IRule rule : rules) {
            for (TypedPreference pref : rule.getConfigurationAttributes()) {
                this.prefRuleMap.computeIfAbsent(pref.getIdentifier(), k -> new ArrayList()).add(rule);
                this.entries.put(pref.getIdentifier(), BasicConfig.createValueEntry(pref));
            }
        }
        this.update(state);
    }

    public Set<IRule> update(IState newState) {
        ArrayList<String> configurationIDs = new ArrayList<String>();
        if (newState != null) {
            IState[] iStateArray = newState.getChildren(STATE_ID);
            int n = iStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                IState config = iStateArray[n2];
                String key = config.getAttribute(KEY_ATTRIBUTE);
                String value = config.getAttribute(VALUE_ATTRIBUTE);
                if (key == null || value == null) {
                    FlightRecorderUI.getDefault().getLogger().warning("Key or value not specified");
                } else {
                    ValueEntry<?> ve = this.entries.get(key);
                    if (ve == null) {
                        FlightRecorderUI.getDefault().getLogger().warning("Attribute for " + key + " is missing");
                    } else {
                        try {
                            boolean parsePersisted = ve.parsePersisted(value);
                            if (parsePersisted) {
                                configurationIDs.add(key);
                            }
                        }
                        catch (QuantityConversionException quantityConversionException) {
                            FlightRecorderUI.getDefault().getLogger().warning("Value '" + value + "' is not a valid for " + key);
                        }
                    }
                }
                ++n2;
            }
        }
        return this.getRulesByConfigurations(configurationIDs);
    }

    <T> T getValue(TypedPreference<T> attr) {
        ValueEntry<?> ve = this.entries.get(attr.getIdentifier());
        if (ve != null) {
            return ve.value;
        }
        return (T)attr.getDefaultValue();
    }

    public void saveTo(IWritableState state) {
        for (ValueEntry<?> ve : this.entries.values()) {
            IWritableState c = state.createChild(STATE_ID);
            c.putString(KEY_ATTRIBUTE, ve.preference.getIdentifier());
            c.putString(VALUE_ATTRIBUTE, ve.persistableString());
        }
    }

    public IAction createOpenConfigAction(final AttributeConfiguration pageConfiguration, final Consumer<Set<IRule>> finisher) {
        return new Action(Messages.CONFIGURATION_EDIT_ACTION, CoreImages.TABLE_SETTINGS){

            public void run() {
                ConfigPage page = new ConfigPage(pageConfiguration.getTitle(), pageConfiguration.getDescription(), pageConfiguration.getPageAttributes());
                if (OnePageWizardDialog.open((IWizardPage)page, (int)500, (int)400) == 0) {
                    List<String> changed = page.getChanged();
                    Set<IRule> rules = BasicConfig.this.getRulesByConfigurations(changed);
                    finisher.accept(rules);
                }
            }
        };
    }

    private Set<IRule> getRulesByConfigurations(List<String> configurationAttributes) {
        HashSet<IRule> rules = new HashSet<IRule>();
        for (String id : configurationAttributes) {
            rules.addAll(this.prefRuleMap.get(id));
        }
        return rules;
    }

    private static <T> ValueEntry<T> createValueEntry(TypedPreference<T> preference) {
        ValueEntry ve = new ValueEntry();
        ve.preference = preference;
        ve.value = preference.getDefaultValue();
        return ve;
    }

    private class ConfigPage
    extends WizardPage
    implements IPerformFinishable {
        private final List<AttributeConfiguration.AttributeGroup> groups;
        private List<String> changedPreferences;

        protected ConfigPage(String title, String description, List<AttributeConfiguration.AttributeGroup> groups) {
            super("BasicConfigPage");
            this.setTitle(title);
            this.setDescription(description);
            this.groups = groups;
            this.changedPreferences = new ArrayList<String>();
        }

        List<String> getChanged() {
            return this.changedPreferences;
        }

        public void createControl(Composite parent) {
            ScrolledComposite container = new ScrolledComposite(parent, 512);
            container.setExpandHorizontal(true);
            container.setExpandVertical(true);
            container.setLayout((Layout)new GridLayout(1, false));
            container.setShowFocusedControl(true);
            Composite configContainer = new Composite((Composite)container, 0);
            container.setContent((Control)configContainer);
            configContainer.setLayoutData((Object)new GridData(4, 4, true, false));
            configContainer.setLayout((Layout)new GridLayout(1, false));
            for (AttributeConfiguration.AttributeGroup group : this.groups) {
                Group attributeGroup = new Group(configContainer, 0);
                attributeGroup.setText(group.getTitle());
                attributeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
                attributeGroup.setLayout((Layout)new GridLayout(2, false));
                for (AttributeConfiguration.GroupEntry entry : group.getEntries()) {
                    TypedPreference<?> preference = entry.getPreference();
                    Label labelText = new Label((Composite)attributeGroup, 8);
                    labelText.setText(entry.getName());
                    labelText.setToolTipText(preference.getDescription());
                    Text text = new Text((Composite)attributeGroup, 0);
                    text.setLayoutData((Object)new GridData(4, -1, true, false));
                    ValueEntry<?> valueEntry = BasicConfig.this.entries.get(preference.getIdentifier());
                    text.setData(valueEntry);
                    text.setText(valueEntry.interactiveFormat());
                    text.setToolTipText(preference.getDescription());
                    QuantityKindProposal.install((Text)text, (IConstraint)preference.getPersister());
                }
            }
            container.setMinSize(configContainer.computeSize(-1, -1));
            this.setControl((Control)container);
        }

        public boolean performFinish() {
            Control container = ((Composite)this.getControl()).getChildren()[0];
            Control[] controlArray = ((Composite)container).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control group = controlArray[n2];
                Control[] controlArray2 = ((Composite)group).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control child = controlArray2[n4];
                    try {
                        Text text;
                        ValueEntry ve;
                        boolean valueChanged;
                        if (child instanceof Text && (valueChanged = (ve = (ValueEntry)(text = (Text)child).getData()).parseInteractive(text.getText()))) {
                            this.changedPreferences.add(ve.preference.getIdentifier());
                        }
                    }
                    catch (QuantityConversionException e) {
                        this.setErrorMessage(e.getLocalizedMessage());
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
    }

    private static class ValueEntry<T> {
        T value;
        TypedPreference<T> preference;

        private ValueEntry() {
        }

        boolean parsePersisted(String persistedValue) throws QuantityConversionException {
            Object parsedValue = this.preference.getPersister().parsePersisted(persistedValue);
            if (this.value.equals(parsedValue)) {
                return false;
            }
            this.value = parsedValue;
            return true;
        }

        boolean parseInteractive(String interactiveValue) throws QuantityConversionException {
            Object parsedValue = this.preference.getPersister().parseInteractive(interactiveValue);
            if (this.value.equals(parsedValue)) {
                return false;
            }
            this.value = parsedValue;
            return true;
        }

        String persistableString() {
            return this.preference.getPersister().persistableString(this.value);
        }

        String interactiveFormat() {
            return this.preference.getPersister().interactiveFormat(this.value);
        }
    }
}

