/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.text.MessageFormat;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.Form;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.ui.AttributeConfiguration;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.misc.OverlayImageDescriptor;

public abstract class AbstractDataPage
implements IDisplayablePage {
    private final IPageDefinition definition;
    private final StreamModel model;
    private final IPageContainer editor;

    @Override
    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor image = this.definition.getImageDescriptor();
        if (FlightRecorderUI.getDefault().isAnalysisEnabled()) {
            Severity s = this.editor.getRuleManager().getMaxSeverity(this.definition.getTopics());
            if (s == Severity.WARNING) {
                return new OverlayImageDescriptor(image, false, new ImageDescriptor[]{FlightRecorderUI.getDefault().getMCImageDescriptor("warning_overlay.png")});
            }
            if (s == Severity.INFO) {
                return new OverlayImageDescriptor(image, false, new ImageDescriptor[]{FlightRecorderUI.getDefault().getMCImageDescriptor("info_overlay.png")});
            }
            return image;
        }
        return image;
    }

    protected Image getIcon() {
        return (Image)JFaceResources.getResources().get((DeviceResourceDescriptor)this.definition.getImageDescriptor());
    }

    protected IState getState() {
        return this.definition.getState();
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    protected String[] getTopics() {
        return this.definition.getTopics();
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder();
        if (this.getConfiguredDescription() != null) {
            description.append(this.getConfiguredDescription());
        }
        if (this.definition.getTopics() != null && this.definition.getTopics().length > 0) {
            if (description.length() > 0) {
                description.append(System.getProperty("line.separator"));
            }
            description.append(this.getRulesStatistics());
        }
        return description.toString();
    }

    protected String getConfiguredDescription() {
        return this.definition.getDescription();
    }

    protected StreamModel getDataSource() {
        return this.model;
    }

    public void addResultConfigurationAction(Form form, AttributeConfiguration config) {
        if (this.editor != null) {
            config.addAttributesFromRules(this.editor.getRuleManager().getRules(this.definition.getTopics()));
            if (config.getPageAttributes().size() > 0 && FlightRecorderUI.getDefault().isAnalysisEnabled()) {
                form.getToolBarManager().add(this.editor.getConfig().createOpenConfigAction(config, this.editor.getRuleManager()::evaluateRules));
                form.getToolBarManager().update(true);
            }
        }
    }

    public void addResultActions(Form form) {
        DataPageToolkit.addRuleResultAction(form, this.editor, () -> this.getDescription(), this.getTopics());
        AttributeConfiguration config = new AttributeConfiguration(this.getName(), MessageFormat.format(Messages.ATTRIBUTE_CONFIG_PAGE_RULES, this.getName()), new AttributeConfiguration.AttributeGroup[0]);
        this.addResultConfigurationAction(form, config);
    }

    public AbstractDataPage(IPageDefinition definition, StreamModel model, IPageContainer editor) {
        this.definition = definition;
        this.model = model;
        this.editor = editor;
    }

    private long getNumberOfInterestingResults() {
        return this.editor.getRuleManager().getResults(this.definition.getTopics()).parallelStream().filter(r -> r.getSeverity().compareTo((Enum)Severity.INFO) >= 0).count();
    }

    private String getRulesStatistics() {
        return MessageFormat.format(Messages.RULES_STATISTICS, this.editor.getRuleManager().getMaxSeverity(this.definition.getTopics()).getLocalizedName(), this.getNumberOfInterestingResults(), this.getNumberOfResults(), Math.round(this.editor.getRuleManager().getScoreStream(this.definition.getTopics()).max().orElse(-1.0)));
    }

    public String toString() {
        return MessageFormat.format("{0}, results: {1}", this.getName(), this.getNumberOfResults());
    }

    private long getNumberOfResults() {
        return this.editor.getRuleManager().getScoreStream(this.getTopics()).count();
    }
}

