/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import org.openjdk.jmc.flightrecorder.ui.selection.IFilterFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;

public class StacktraceFrameSelection
extends FlavoredSelectionBase {
    private IMCFrame frame;
    private IItemCollection selectedItems;

    public StacktraceFrameSelection(IMCFrame frame, IItemCollection selectedItems, String name) {
        super(name);
        this.frame = frame;
        this.selectedItems = selectedItems;
    }

    @Override
    public Stream<IItemStreamFlavor> getFlavors(IItemFilter filter, IItemCollection items, List<IAttribute<?>> attributes) {
        Stream.Builder<IItemStreamFlavor> builder = Stream.builder();
        builder.add(IItemStreamFlavor.build(MessageFormat.format(Messages.FLAVOR_SELECTED_EVENTS, ItemCollectionToolkit.getDescription((IItemCollection)this.selectedItems)), this.selectedItems));
        builder.add(StacktraceFrameSelection.buildContainsMethodFlavor(this.frame.getMethod(), items));
        return builder.build();
    }

    private static IFilterFlavor buildContainsMethodFlavor(final IMCMethod method, final IItemCollection items) {
        return new IFilterFlavor(){

            @Override
            public String getName() {
                return MessageFormat.format(Messages.FLAVOR_CONTAINS, JdkAttributes.STACK_TRACE_STRING.getName(), FormatToolkit.getHumanReadable((IMCMethod)method));
            }

            @Override
            public IItemCollection evaluate() {
                return items.apply(this.getFilter());
            }

            @Override
            public IItemFilter getFilter() {
                return ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_STRING, (String)FormatToolkit.getHumanReadable((IMCMethod)method));
            }
        };
    }
}

