/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.labelingrules;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.common.labelingrules.NamingRule;
import org.openjdk.jmc.common.resource.Resource;
import org.openjdk.jmc.ui.common.CorePlugin;

public class NameConverterRulesInitializer {
    private static final String LABELING_RULES_EXTENSION_POINT = "org.openjdk.jmc.ui.common.labelingRules";
    private static final String ATTRIBUTE_ICON = "icon";
    private static final Comparator<NamingRule> COMPARATOR = new Comparator<NamingRule>(){

        @Override
        public int compare(NamingRule o1, NamingRule o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    public static List<NamingRule> initializeRulesFromExtensions() {
        IExtension[] extensions;
        ArrayList<NamingRule> rules = new ArrayList<NamingRule>();
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(LABELING_RULES_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("rule")) {
                    try {
                        rules.add(NameConverterRulesInitializer.createRule(config));
                    }
                    catch (Exception e) {
                        CorePlugin.getDefault().getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        rules.sort(COMPARATOR);
        return rules;
    }

    private static NamingRule createRule(IConfigurationElement config) throws Exception {
        String name = config.getAttribute("name");
        try {
            int priority = Integer.parseInt(config.getAttribute("priority"));
            String matchingPart = config.getAttribute("match");
            String formattingPart = config.getAttribute("format");
            return new NamingRule(name, matchingPart, formattingPart, priority, NameConverterRulesInitializer.getIcon(config));
        }
        catch (Exception exception) {
            throw new Exception("Problem instantiating naming rule named " + name);
        }
    }

    private static Resource getIcon(IConfigurationElement configElement) {
        String iconName = configElement.getAttribute(ATTRIBUTE_ICON);
        if (iconName != null) {
            String extendingPluginId = configElement.getDeclaringExtension().getContributor().getName();
            return new Resource(extendingPluginId, iconName);
        }
        return null;
    }
}

