/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jolokia.server.core.util.Base64Util;
import org.jolokia.server.core.util.ClassUtil;

public class JolokiaCipher {
    private static final int SALT_SIZE = 8;
    private static final int CHUNK_SIZE = 16;
    static final String JOLOKIA_CYPHER_PASSWORD_FILE = "META-INF/jolokia-password";
    private final MessageDigest digest = MessageDigest.getInstance("SHA-256");
    private final Random random = new SecureRandom();
    private final KeyHolder keyHolder;

    public JolokiaCipher() throws GeneralSecurityException {
        this(new KeyHolderImpl());
    }

    public JolokiaCipher(KeyHolder pKeyHolder) throws NoSuchAlgorithmException {
        this.keyHolder = pKeyHolder;
        this.random.setSeed(System.currentTimeMillis());
    }

    public String encrypt(String pText) throws GeneralSecurityException {
        byte[] clearBytes = pText.getBytes(StandardCharsets.UTF_8);
        byte[] salt = this.getSalt(8);
        Cipher cipher = this.createCipher(salt, 1);
        byte[] encryptedBytes = cipher.doFinal(clearBytes);
        int len = encryptedBytes.length;
        byte padLen = (byte)(16 - (8 + len + 1) % 16);
        int totalLen = 8 + len + padLen + 1;
        byte[] allEncryptedBytes = this.getSalt(totalLen);
        System.arraycopy(salt, 0, allEncryptedBytes, 0, 8);
        allEncryptedBytes[8] = padLen;
        System.arraycopy(encryptedBytes, 0, allEncryptedBytes, 9, len);
        return Base64Util.encode(allEncryptedBytes);
    }

    public String decrypt(String pEncryptedText) throws GeneralSecurityException {
        byte[] allEncryptedBytes = Base64Util.decode(pEncryptedText);
        int totalLen = allEncryptedBytes.length;
        byte[] salt = new byte[8];
        System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
        byte padLen = allEncryptedBytes[8];
        byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
        System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
        Cipher cipher = this.createCipher(salt, 2);
        byte[] clearBytes = cipher.doFinal(encryptedBytes);
        return new String(clearBytes, StandardCharsets.UTF_8);
    }

    private byte[] getSalt(int sz) {
        byte[] res = new byte[sz];
        this.random.nextBytes(res);
        return res;
    }

    private Cipher createCipher(byte[] salt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        this.digest.reset();
        byte[] pwdAsBytes = this.getKeyAsBytes();
        byte[] keyAndIv = new byte[32];
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            this.digest.update(pwdAsBytes);
            this.digest.update(salt, 0, 8);
            byte[] result = this.digest.digest();
            int stillNeed = keyAndIv.length - currentPos;
            if (result.length > stillNeed) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            this.digest.reset();
            this.digest.update(result);
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        return cipher;
    }

    private byte[] getKeyAsBytes() {
        return this.keyHolder.getKey().getBytes(StandardCharsets.UTF_8);
    }

    private static class KeyHolderImpl
    implements KeyHolder {
        private KeyHolderImpl() {
        }

        @Override
        public String getKey() {
            InputStream in = ClassUtil.getResourceAsStream(JolokiaCipher.JOLOKIA_CYPHER_PASSWORD_FILE);
            if (in != null) {
                String string;
                block9: {
                    InputStream inputStream = in;
                    try {
                        string = new BufferedReader(new InputStreamReader(in)).readLine();
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Can not read password from META-INF/jolokia-password: " + e, e);
                        }
                    }
                    inputStream.close();
                }
                return string;
            }
            return "`x%_rDL9T'&ENuyA{LPcc(UDv`NzzY6NZF\"F=rba-9Ftg,HJr.y@E;amfr>B4z<UqQg}2_4kq\\Y@6mNJEpwGx#CT;&?%%.$T_br`(&%3)2vC:5?3f9ptX?KR9kYQu2;#".substring(40, 72);
        }
    }

    public static interface KeyHolder {
        public String getKey();
    }
}

