/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.celleditors;

import java.lang.reflect.Array;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.ui.celleditors.Messages;
import org.openjdk.jmc.ui.celleditors.NumberCellEditor;

public class ArrayLengthCellEditor
extends NumberCellEditor<Integer> {
    private final Class<?> arrayType;
    private Object oldArray;

    public ArrayLengthCellEditor(Composite parent, Class<?> arrayType) {
        super(parent, Integer.class, true, false);
        this.arrayType = arrayType;
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(String.valueOf(arrayType) + " is not an array type");
        }
    }

    @Override
    protected void doSetValue(Object value) {
        this.oldArray = value;
        if (value == null) {
            super.doSetValue(null);
        } else if (this.arrayType.isAssignableFrom(value.getClass())) {
            super.doSetValue(Array.getLength(value));
        }
    }

    @Override
    protected Object doGetValue() {
        Object newLength = super.doGetValue();
        if (!(newLength instanceof Integer)) {
            return null;
        }
        if (this.oldArray != null && newLength.equals(Array.getLength(this.oldArray))) {
            return this.oldArray;
        }
        return Array.newInstance(this.arrayType.getComponentType(), (int)((Integer)newLength));
    }

    @Override
    public String getInfoText() {
        return Messages.ArrayLengthCellEditor_ENTER_THE_LENGTH_OF_THE_ARRAY + "\n" + super.getInfoText();
    }
}

