/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FinalizersRunRule
implements IRule {
    private static final String FINALIZERS_RUN_RESULT_ID = "FinalizersRun";
    private static final TypedResult<IQuantity> FINALIZERS_RUN_COUNT = new TypedResult("finalizersRunCount", Messages.getString("FinalizersRunRule_RESULT_FINALIZERS_RUN_COUNT"), Messages.getString("FinalizersRunRule_RESULT_FINALIZERS_RUN_COUNT_DESC"), (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final TypedCollectionResult<String> FINALIZERS_RUN_CLASSES = new TypedCollectionResult("finalizersRunClasses", Messages.getString("FinalizersRunRule_RESULT_FINALIZERS_RUN_CLASSES"), Messages.getString("FinalizersRunRule_RESULT_FINALIZERS_RUN_CLASSES_DESC"), UnitLookup.PLAIN_TEXT, String.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(FINALIZERS_RUN_COUNT, FINALIZERS_RUN_CLASSES);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.FinalizerStatistics", RulesToolkit.EventAvailability.AVAILABLE).build();
    private static final TypedPreference<String> FINALIZABLE_CLASSES_INCLUDE_REGEXP = new TypedPreference("finalizable.classes.include.regexp", Messages.getString("FinalizersRunRule_CONFIG_FINALIZABLE_CLASSES_INCLUDE_REGEXP"), Messages.getString("FinalizersRunRule_CONFIG_FINALIZABLE_CLASSES_INCLUDE_REGEXP_DESC"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"^(?!java\\.|javax\\.|sun\\.|com\\.sun\\.|jdk\\.|scala\\.|kotlin\\.|kotlinx\\.|groovy\\.|closure\\.).*$");
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(FINALIZABLE_CLASSES_INCLUDE_REGEXP);

    public RunnableFuture<IResult> createEvaluation(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        return new FutureTask<IResult>(() -> this.getResult(items, valueProvider));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    public String getId() {
        return FINALIZERS_RUN_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FinalizersRunRule_RULE_NAME");
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public String getTopic() {
        return "java_application";
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        String classesIncludeRegex = (String)valueProvider.getPreferenceValue(FINALIZABLE_CLASSES_INCLUDE_REGEXP);
        IItemFilter finalizerStatisticsEventsFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.FinalizerStatistics"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FINALIZABLE_CLASS_NAME, (String)classesIncludeRegex)});
        IItemCollection finalizerStatisticsEvents = items.apply(finalizerStatisticsEventsFilter);
        long totalCount = 0L;
        HashSet<String> finalizableClasses = new HashSet<String>();
        for (IItemIterable eventIterable : finalizerStatisticsEvents) {
            IMemberAccessor finalizableClassAccessor = JdkAttributes.FINALIZABLE_CLASS.getAccessor(eventIterable.getType());
            IMemberAccessor totalFinalizersRunAccessor = JdkAttributes.TOTAL_FINALIZERS_RUN.getAccessor(eventIterable.getType());
            for (IItem event : eventIterable) {
                long countforEvent;
                IMCType finalizableClass = (IMCType)finalizableClassAccessor.getMember((Object)event);
                IQuantity totalFinalizersRun = (IQuantity)totalFinalizersRunAccessor.getMember((Object)event);
                if (finalizableClass == null || totalFinalizersRun == null || (countforEvent = totalFinalizersRun.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY)) <= 0L) continue;
                totalCount += countforEvent;
                finalizableClasses.add(finalizableClass.getFullName());
            }
        }
        if (totalCount <= 0L) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("FinalizersRunRule_SUMMARY_OK")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("FinalizersRunRule_SUMMARY_WARN")).setExplanation(Messages.getString("FinalizersRunRule_EXPLANATION")).setSolution(Messages.getString("FinalizersRunRule_SOLUTION")).addResult(FINALIZERS_RUN_COUNT, (Object)UnitLookup.NUMBER_UNITY.quantity(totalCount)).addResult(FINALIZERS_RUN_CLASSES, finalizableClasses).build();
    }
}

