/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import java.awt.Polygon;
import java.util.Iterator;
import org.openjdk.jmc.common.xydata.DataSeries;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.impl.LongWorldToDeviceConverter;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.impl.WorldToDeviceConverter;
import org.openjdk.jmc.greychart.providers.SampleCountingProvider;
import org.openjdk.jmc.greychart.providers.SamplePointIterator;
import org.openjdk.jmc.greychart.providers.StackingBuffer;

public class IntermediateStackingProvider
implements OptimizingProvider {
    private final OptimizingProvider[] providers;
    private final OptimizingProvider topProvider;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private int m_requestedResolution = 0;
    private StackingBuffer m_sampleBuffer;
    private int m_lastSubSampleWidth = -1;
    private volatile boolean dataChangeOccured;

    public IntermediateStackingProvider(OptimizingProvider topProvider, OptimizingProvider[] providers) {
        int nProviders = 0;
        OptimizingProvider[] optimizingProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider prov = optimizingProviderArray[n2];
            if (prov != null) {
                ++nProviders;
            }
            ++n2;
        }
        OptimizingProvider[] myProviders = new OptimizingProvider[nProviders];
        int index = 0;
        OptimizingProvider[] optimizingProviderArray2 = providers;
        int n3 = providers.length;
        int n4 = 0;
        while (n4 < n3) {
            OptimizingProvider prov = optimizingProviderArray2[n4];
            if (prov != null) {
                myProviders[index] = prov;
                ++index;
            }
            ++n4;
        }
        this.providers = myProviders;
        this.topProvider = topProvider;
        this.m_sampleBuffer = new StackingBuffer(0);
    }

    @Override
    public void setDataChanged(boolean changed) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setDataChanged(changed);
            ++n2;
        }
        this.dataChangeOccured = true;
    }

    @Override
    public boolean hasDataChanged() {
        if (this.dataChangeOccured) {
            return true;
        }
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            if (provider.hasDataChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasRangeChanged() {
        return this.getMinX() != this.m_requestedStartX || this.getMaxX() != this.m_requestedEndX;
    }

    private StackingBuffer createStackSampledBuffer(int width) {
        this.dataChangeOccured = false;
        this.m_lastSubSampleWidth = width;
        StackingBuffer stackSampleBuffer = new StackingBuffer(width);
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            Iterator<SamplePoint> it = provider.getSamples(width);
            stackSampleBuffer.startSeries();
            while (it.hasNext()) {
                SamplePoint point = it.next();
                stackSampleBuffer.addNonNormalizedDataPoint(point.x, point.y);
            }
            ++n2;
        }
        return stackSampleBuffer;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        if (width != this.m_lastSubSampleWidth || this.hasDataChanged() || this.hasRangeChanged()) {
            this.m_sampleBuffer = this.createStackSampledBuffer(width);
        }
        return new SamplePointIterator(this.m_sampleBuffer.getSamples());
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        int[] xs = new int[deviceWidth * 2 + 3];
        int[] ys = new int[deviceWidth * 2 + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = this.getSamples(deviceWidth);
            int previousY = 0;
            boolean sampleCounting = this.topProvider instanceof SampleCountingProvider;
            int onePixelY = yWorldToDevice.getDeviceCoordinate(0.0) - 2;
            while (it.hasNext() && index < deviceWidth * 2) {
                SamplePoint sp = it.next();
                int currentY = yWorldToDevice.getDeviceCoordinate(sp.y);
                if (sampleCounting) {
                    if (sp.y > 0.0 && currentY > onePixelY) {
                        currentY = onePixelY;
                    }
                    if (currentY != previousY && index > 0) {
                        xs[index] = sp.x;
                        ys[index] = previousY;
                        ++index;
                    }
                    xs[index] = sp.x;
                    ys[index] = currentY;
                    ++index;
                    previousY = currentY;
                    continue;
                }
                if (sp.count <= 0L) continue;
                xs[index] = sp.x;
                ys[index] = currentY;
                ++index;
            }
        }
        return new Polygon(xs, ys, index);
    }

    @Override
    public void setResolution(int resolution) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setResolution(resolution);
            ++n2;
        }
        this.m_requestedResolution = resolution;
    }

    @Override
    public boolean update() {
        boolean update = false;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            if (provider.update()) {
                update = true;
            }
            ++n2;
        }
        return update;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return this.providers;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.topProvider.getDataSeries();
    }

    @Override
    public long getMaxX() {
        return this.topProvider.getMaxX();
    }

    @Override
    public double getMaxY() {
        if (this.hasDataChanged() || this.hasRangeChanged() || this.m_sampleBuffer.getSize() == 0) {
            this.m_sampleBuffer = this.createStackSampledBuffer(this.m_requestedResolution);
        }
        return this.m_sampleBuffer.getMaxY();
    }

    @Override
    public double getMinY() {
        if (this.hasDataChanged() || this.hasRangeChanged() || this.m_sampleBuffer.getSize() == 0) {
            this.m_sampleBuffer = this.createStackSampledBuffer(this.m_requestedResolution);
        }
        return this.m_sampleBuffer.getMinY();
    }

    @Override
    public WorldToDeviceConverter getYSampleToDeviceConverterFor(YAxis yAxis) {
        double minY = yAxis.getMin().doubleValue();
        double maxY = yAxis.getMax().doubleValue();
        return new WorldToDeviceConverter(yAxis.getRenderedHeight(), 0, minY, maxY);
    }

    @Override
    public long getMinX() {
        return this.topProvider.getMinX();
    }

    @Override
    public void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setRange(start, end);
            ++n2;
        }
    }

    public void setIntegrate(boolean integrate) {
    }
}

