/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.AggregatableFrame;

public final class Node {
    private final AggregatableFrame frame;
    double weight;
    Node parent;
    final List<Node> children = new ArrayList<Node>();
    double cumulativeWeight;

    public static Node newRootNode(AggregatableFrame rootFrame) {
        return new Node(null, rootFrame);
    }

    public Node(Node parent, AggregatableFrame frame) {
        this.parent = parent;
        this.frame = frame;
        if (frame == null) {
            throw new NullPointerException("Frame cannot be null!");
        }
    }

    public double getWeight() {
        return this.weight;
    }

    public double getCumulativeWeight() {
        return this.cumulativeWeight;
    }

    public AggregatableFrame getFrame() {
        return this.frame;
    }

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public int hashCode() {
        return this.frame.getMethod().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.frame, other.frame) && this.weight == other.weight && this.cumulativeWeight == other.cumulativeWeight;
    }

    public String toString() {
        return String.format("%s %.2f (%.2f)", this.frame.getHumanReadableShortString(), this.weight, this.cumulativeWeight);
    }
}

