/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.accessibility;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public final class FocusTracker {
    private static final String TRACKER_KEY = FocusTracker.class.getName();
    private final Composite m_composite;
    private final KeyListener m_keyListener;
    private final FocusListener m_focusListener;
    private final PaintListener m_paintListener;
    private final DisposeListener m_disposeListener;
    private final SimpleTraverseListener m_traverseListener;

    private FocusTracker(Composite composite) {
        this.m_composite = composite;
        this.m_keyListener = new EmptyKeyListener();
        this.m_focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                FocusTracker.this.scheduleRepaint();
            }

            public void focusLost(FocusEvent e) {
                FocusTracker.this.scheduleRepaint();
            }
        };
        this.m_paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (FocusTracker.this.m_composite.isFocusControl()) {
                    FocusTracker.drawFocusOn(FocusTracker.this.m_composite, e.gc);
                }
            }
        };
        this.m_disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FocusTracker.this.disable();
            }
        };
        this.m_traverseListener = new SimpleTraverseListener(true);
    }

    public static void drawFocusOn(Composite composite, GC gc) {
        Rectangle clientArea = composite.getClientArea();
        gc.drawFocus(0, 0, clientArea.width, clientArea.height);
    }

    public static void enableFocusTracking(Composite composite) {
        if (!FocusTracker.hasFocusTracker(composite)) {
            new FocusTracker(composite).enable();
        }
    }

    public static void disableFocusTracking(Composite composite) {
        if (FocusTracker.hasFocusTracker(composite)) {
            FocusTracker.getFocusTracker(composite).disable();
        }
    }

    public static boolean hasFocusTracker(Composite composite) {
        return FocusTracker.getFocusTracker(composite) != null;
    }

    public static FocusTracker getFocusTracker(Composite composite) {
        Object object = composite.getData(TRACKER_KEY);
        if (object instanceof FocusTracker) {
            return (FocusTracker)object;
        }
        return null;
    }

    private void scheduleRepaint() {
        DisplayToolkit.safeAsyncExec((Widget)this.m_composite, new Runnable(){

            @Override
            public void run() {
                FocusTracker.this.m_composite.redraw();
            }
        });
    }

    private void enable() {
        this.m_composite.addKeyListener(this.m_keyListener);
        this.m_composite.addFocusListener(this.m_focusListener);
        this.m_composite.addPaintListener(this.m_paintListener);
        this.m_composite.addDisposeListener(this.m_disposeListener);
        this.m_composite.addTraverseListener((TraverseListener)this.m_traverseListener);
        this.m_composite.setData(TRACKER_KEY, (Object)this);
    }

    private void disable() {
        if (!this.m_composite.isDisposed()) {
            this.m_composite.removeKeyListener(this.m_keyListener);
            this.m_composite.removeFocusListener(this.m_focusListener);
            this.m_composite.removePaintListener(this.m_paintListener);
            this.m_composite.removeDisposeListener(this.m_disposeListener);
            this.m_composite.removeTraverseListener((TraverseListener)this.m_traverseListener);
            this.m_composite.setData(TRACKER_KEY, (Object)TRACKER_KEY);
        }
    }

    private static class EmptyKeyListener
    extends KeyAdapter {
        private EmptyKeyListener() {
        }
    }
}

