/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RenderedRowBase;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYQuantities;

public class QuantitySpanRenderer
implements IXDataRenderer {
    public static final IQuantity MISSING_START = UnitLookup.EPOCH_S.quantity(0L);
    public static final IQuantity MISSING_END = UnitLookup.EPOCH_S.quantity(Long.MAX_VALUE);
    private final IQuantitySeries<?> ranges;
    private final Paint paint;
    private final int minOutlineHeight;
    private final IXDataRenderer content;
    private final String text;
    private final String description;
    private final Object data;

    public QuantitySpanRenderer(IQuantitySeries<?> ranges, IXDataRenderer content, Paint paint, int minOutlineHeight, String text, String description, Object data) {
        this.ranges = ranges;
        this.content = content;
        this.paint = paint;
        this.minOutlineHeight = minOutlineHeight;
        this.text = text;
        this.description = description;
        this.data = data;
    }

    private static int calcMargin(int height) {
        return Math.min(5, (height + 10) / 20);
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
        int margin = QuantitySpanRenderer.calcMargin(height);
        int innerHeight = height - 2 * margin;
        context.translate(0, margin);
        context.setPaint(this.paint);
        XYQuantities<?> quantities = this.ranges.getQuantities(xRange);
        quantities.setYRange(xRange);
        AWTChartToolkit.drawRanges(context, quantities, innerHeight, true);
        IRenderedRow renderedContent = this.content.render(context, xRange, innerHeight);
        if (innerHeight >= this.minOutlineHeight) {
            context.setPaint(Color.BLACK);
            AWTChartToolkit.drawRanges(context, quantities, innerHeight, false);
        }
        context.translate(0, -margin);
        return new QuantitySpanRendering(margin, quantities, renderedContent, this.paint, this.text, this.description, this.data);
    }

    private static class QuantitySpanRendering
    extends RenderedRowBase {
        private final XYQuantities<?> points;
        private final IRenderedRow content;
        private final Paint paint;
        private final int margin;
        private final String description;
        private final Object data;

        public QuantitySpanRendering(int margin, XYQuantities<?> points, IRenderedRow content, Paint paint, String text, String description, Object data) {
            super(Arrays.asList(new RenderedRowBase(margin), content, new RenderedRowBase(margin)), content.getHeight() + 2 * margin, text, description, null);
            this.margin = margin;
            this.points = points;
            this.content = content;
            this.paint = paint;
            this.description = description;
            this.data = data;
        }

        @Override
        public void infoAt(IChartInfoVisitor visitor, int x, int y, Point offset) {
            int bucket;
            visitor.hover(this.data);
            offset = new Point(offset.x, offset.y + this.margin);
            this.content.infoAt(visitor, x, y, offset);
            if (this.points != null && (bucket = this.points.floorIndexAtX(x)) < this.points.getSize()) {
                Span span = new Span(bucket, offset);
                if (visitor.isChartTextCanvas() && bucket == -1) {
                    bucket = 0;
                }
                while (bucket >= 0) {
                    double x2 = this.points.getPixelY(bucket);
                    if ((double)x < x2) {
                        span.setIndex(bucket);
                        visitor.visit(span);
                        break;
                    }
                    --bucket;
                }
            }
        }

        private class Span
        extends XYQuantities.AbstractSpan {
            public Span(int index, Point2D offset) {
                super(index, offset);
            }

            @Override
            protected XYQuantities<?> getXYSet() {
                return QuantitySpanRendering.this.points;
            }

            @Override
            protected int getHeight() {
                return QuantitySpanRendering.this.content.getHeight();
            }

            @Override
            public Color getColor() {
                return QuantitySpanRendering.this.paint instanceof Color ? (Color)QuantitySpanRendering.this.paint : null;
            }

            private void setIndex(int index) {
                this.index = index;
            }

            @Override
            public IQuantity getStartX() {
                IQuantity org = super.getStartX();
                return org == MISSING_START ? null : org;
            }

            @Override
            public IQuantity getEndX() {
                IQuantity org = super.getEndX();
                return org == MISSING_END ? null : org;
            }

            @Override
            public String getDescription() {
                return QuantitySpanRendering.this.description;
            }
        }
    }
}

