/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.Collection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.openjdk.jmc.common.tree.IArray;
import org.openjdk.jmc.common.tree.IParent;
import org.openjdk.jmc.ui.common.tree.IChild;
import org.openjdk.jmc.ui.common.tree.ITreeNode;
import org.openjdk.jmc.ui.misc.MCArrayContentProvider;

public class TreeStructureContentProvider
extends MCArrayContentProvider
implements ITreeContentProvider {
    public static final TreeStructureContentProvider INSTANCE = new TreeStructureContentProvider();

    public boolean hasChildren(Object element) {
        if (element instanceof IArray) {
            return !((IArray)element).isEmpty();
        }
        if (element instanceof IParent) {
            return ((IParent)element).hasChildren();
        }
        if (element.getClass().isArray()) {
            return ((Object[])element).length > 0;
        }
        if (element instanceof Collection) {
            return ((Collection)element).size() > 0;
        }
        if (element instanceof ITreeNode) {
            ITreeNode[] children = ((ITreeNode)element).getChildren();
            return children == null ? false : children.length > 0;
        }
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof ITreeNode) {
            return ((ITreeNode)element).getParent();
        }
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        if (element instanceof IChild) {
            return ((IChild)element).getParent();
        }
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IParent) {
            return ((IParent)inputElement).getChildren().toArray();
        }
        if (inputElement instanceof ITreeNode) {
            return ((ITreeNode)inputElement).getChildren();
        }
        if (inputElement instanceof TreeNode) {
            return ((TreeNode)inputElement).getChildren();
        }
        return super.getElements(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }
}

