/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.ui.views;

import java.util.Observable;
import java.util.logging.Level;
import org.eclipse.ui.IMemento;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.greychart.data.RenderingMode;
import org.openjdk.jmc.ui.UIPlugin;

public class ChartModel
extends Observable {
    public static final String XML_TAG_CHART_MODEL = "chartModel";
    public static final String XML_Y_RANGE_SETTING = "yRangeSetting";
    public static final String XML_RENDERING_MODE_SETTING = "renderingModeSetting";
    public static final String XML_KIND_OF_QUANTITY = "kindOfQuantity";
    public static final String XML_FROM_RANGE_TYPE = "rangeFromType";
    public static final String XML_FROM_RANGE_VALUE = "rangeFromValue";
    public static final String XML_TO_RANGE_TYPE = "rangeToType";
    public static final String XML_TO_RANGE_VALUE = "rangeToValue";
    public static final String XML_Y_AXIS_TITLE = "yAxisTitle";
    public static final String XML_X_AXIS_TITLE = "xAxisTitle";
    public static final String XML_CHART_TITLE = "chartTitle";
    public static final String NO_VALUE = "";
    private final Axis m_xAxis = new Axis();
    private final RangedAxis m_yAxis = new RangedAxis();
    private String m_title;
    private RenderingMode m_renderingMode = RenderingMode.SUBSAMPLING;

    public Axis getXAxis() {
        return this.m_xAxis;
    }

    public RangedAxis getYAxis() {
        return this.m_yAxis;
    }

    public String getComponentTag() {
        return XML_TAG_CHART_MODEL;
    }

    public void setRenderingMode(RenderingMode mode) {
        this.m_renderingMode = mode;
        this.setChanged();
    }

    public RenderingMode getRenderingMode() {
        return this.m_renderingMode;
    }

    public void setChartTitle(String title) {
        this.m_title = title;
        this.setChanged();
    }

    public String getChartTitle() {
        return this.m_title == null ? NO_VALUE : this.m_title;
    }

    public void saveState(IMemento memento) {
        memento.putString(XML_Y_RANGE_SETTING, this.getYAxis().getRangeType().toString());
        memento.putString(XML_FROM_RANGE_TYPE, this.getYAxis().getMinValue().getUnit().getContentType().getIdentifier());
        memento.putString(XML_FROM_RANGE_VALUE, this.getYAxis().getMinValue().persistableString());
        memento.putString(XML_TO_RANGE_TYPE, this.getYAxis().getMaxValue().getUnit().getContentType().getIdentifier());
        memento.putString(XML_TO_RANGE_VALUE, this.getYAxis().getMaxValue().persistableString());
        memento.putString(XML_Y_AXIS_TITLE, this.m_yAxis.m_title);
        memento.putString(XML_X_AXIS_TITLE, this.m_xAxis.m_title);
        memento.putString(XML_CHART_TITLE, this.m_title);
        memento.putString(XML_KIND_OF_QUANTITY, this.getYAxis().getKindOfQuantity().getIdentifier());
        memento.putString(XML_RENDERING_MODE_SETTING, this.getRenderingMode().toString());
    }

    public void restoreState(IMemento memento) {
        LinearKindOfQuantity kindOfQuantity = UnitLookup.NUMBER;
        try {
            String quantityId = memento.getString(XML_KIND_OF_QUANTITY);
            if (quantityId != null) {
                ContentType contentType = UnitLookup.getContentType((String)quantityId);
                kindOfQuantity = contentType instanceof KindOfQuantity ? (KindOfQuantity)contentType : UnitLookup.NUMBER;
            }
        }
        catch (IllegalArgumentException ex) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading range values.", ex);
        }
        this.getYAxis().setKindOfQuantity((KindOfQuantity<?>)kindOfQuantity);
        AxisRange yRangeValue = AxisRange.AUTO_ZERO;
        ITypedQuantity minValue = UnitLookup.NUMBER.getDefaultUnit().quantity(0L);
        ITypedQuantity maxValue = UnitLookup.NUMBER.getDefaultUnit().quantity(100L);
        try {
            String rangeSetting = memento.getString(XML_Y_RANGE_SETTING);
            if (rangeSetting != null) {
                yRangeValue = AxisRange.valueOf(rangeSetting);
            }
            minValue = ChartModel.restoreTypeValue(memento, XML_FROM_RANGE_TYPE, XML_FROM_RANGE_VALUE, (IQuantity)minValue);
            maxValue = ChartModel.restoreTypeValue(memento, XML_TO_RANGE_TYPE, XML_TO_RANGE_VALUE, (IQuantity)maxValue);
        }
        catch (IllegalArgumentException ex) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading range values.", ex);
        }
        catch (QuantityConversionException ex) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading range values.", ex);
        }
        this.getYAxis().setRangeType(yRangeValue);
        this.getYAxis().setMinValue((IQuantity)minValue);
        this.getYAxis().setMaxValue((IQuantity)maxValue);
        try {
            String renderingMode = memento.getString(XML_RENDERING_MODE_SETTING);
            if (renderingMode != null) {
                this.setRenderingMode(RenderingMode.valueOf((String)renderingMode));
            }
        }
        catch (IllegalArgumentException ex) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading rendering mode.", ex);
        }
        this.getYAxis().setTitle(memento.getString(XML_Y_AXIS_TITLE));
        this.getXAxis().setTitle(memento.getString(XML_X_AXIS_TITLE));
        this.setChartTitle(memento.getString(XML_CHART_TITLE));
        this.getXAxis().notifyObservers();
        this.getYAxis().notifyObservers();
        this.notifyObservers();
    }

    private static IQuantity restoreTypeValue(IMemento memento, String typeKey, String valueKey, IQuantity defaultValue) throws QuantityConversionException {
        String fromRangeTypeId = memento.getString(typeKey);
        if (fromRangeTypeId != null) {
            ContentType contentType = UnitLookup.getContentType((String)fromRangeTypeId);
            LinearKindOfQuantity fromRangeType = contentType instanceof KindOfQuantity ? (KindOfQuantity)contentType : UnitLookup.NUMBER;
            String valueString = memento.getString(valueKey);
            if (valueString != null) {
                return fromRangeType.parsePersisted(valueString);
            }
        }
        return defaultValue;
    }

    public static class Axis
    extends Observable {
        String m_title;

        public String getTitle() {
            return this.m_title == null ? ChartModel.NO_VALUE : this.m_title;
        }

        public void setTitle(String title) {
            this.m_title = title;
            this.setChanged();
        }
    }

    public static enum AxisRange {
        AUTO,
        CUSTOM,
        AUTO_ZERO;

    }

    public static class RangedAxis
    extends Axis {
        private AxisRange m_rangeType = AxisRange.AUTO_ZERO;
        private KindOfQuantity<?> m_kindOfQuantity = UnitLookup.NUMBER;
        private IQuantity m_minValue = this.m_kindOfQuantity.getDefaultUnit().quantity(0L);
        private IQuantity m_maxValue = this.m_kindOfQuantity.getDefaultUnit().quantity(100L);

        public IQuantity getMinValue() {
            return this.m_minValue;
        }

        public IQuantity getMaxValue() {
            return this.m_maxValue;
        }

        public void setMinValue(IQuantity minValue) {
            if (minValue.getUnit().getContentType() == this.m_kindOfQuantity && !minValue.equals(this.m_minValue)) {
                this.m_minValue = minValue;
                this.setChanged();
            }
        }

        public void setMaxValue(IQuantity maxValue) {
            if (maxValue.getUnit().getContentType() == this.m_kindOfQuantity && !maxValue.equals(this.m_maxValue)) {
                this.m_maxValue = maxValue;
                this.setChanged();
            }
        }

        public void setRangeType(AxisRange rangeType) {
            if (rangeType != this.m_rangeType) {
                this.m_rangeType = rangeType;
                this.setChanged();
            }
        }

        public AxisRange getRangeType() {
            if (!(this.m_rangeType != AxisRange.CUSTOM || this.m_kindOfQuantity.equals((Object)this.m_minValue.getUnit().getContentType()) && this.m_kindOfQuantity.equals((Object)this.m_maxValue.getUnit().getContentType()))) {
                return this.m_minValue.doubleValue() <= 0.0 && this.m_maxValue.doubleValue() >= 0.0 ? AxisRange.AUTO_ZERO : AxisRange.AUTO;
            }
            return this.m_rangeType;
        }

        public void setKindOfQuantity(KindOfQuantity<?> type) {
            if (!this.m_kindOfQuantity.equals(type)) {
                this.m_kindOfQuantity = type;
                this.setChanged();
            }
        }

        public KindOfQuantity<?> getKindOfQuantity() {
            return this.m_kindOfQuantity;
        }
    }
}

