/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.Colors;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameRenderer;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import io.github.bric3.fireplace.flamegraph.ZoomTarget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlamegraphRenderEngine<T> {
    static final boolean DEFAULT_ICICLE_MODE = true;
    private final int minimapFrameBoxHeight = 1;
    private final double frameWidthVisibilityThreshold = 2.0;
    public final boolean paintHoveredFrameBorder = false;
    public final Supplier<Color> frameBorderColor = () -> Colors.panelForeground;
    private boolean showHoveredSiblings = true;
    @NotNull
    private final FrameRenderer<T> frameRenderer;
    @Nullable
    private FrameBox<T> hoveredFrame;
    @Nullable
    private FrameBox<T> selectedFrame;
    @NotNull
    private Set<FrameBox<T>> toHighlight = Collections.emptySet();
    @NotNull
    private Set<FrameBox<T>> hoveredSiblingFrames = Collections.emptySet();
    @NotNull
    private FrameModel<T> frameModel = FrameModel.empty();
    private int depth;
    private int visibleDepth;
    private final WeakHashMap<Integer, Integer> visibleDepthCache = new WeakHashMap();
    private boolean icicle = true;

    public int getVisibleDepth() {
        return this.visibleDepth;
    }

    public FlamegraphRenderEngine(@NotNull @NotNull FrameRenderer<@NotNull T> frameRenderer) {
        this.frameRenderer = Objects.requireNonNull(frameRenderer, "frameRenderer");
        this.reset();
    }

    @NotNull
    public @NotNull FlamegraphRenderEngine<@NotNull T> init(@NotNull @NotNull FrameModel<@NotNull T> frameModel) {
        this.frameModel = Objects.requireNonNull(frameModel, "frameModel");
        this.visibleDepth = this.depth = frameModel.frames.stream().mapToInt(fb -> fb.stackDepth).max().orElse(0) + 1;
        this.visibleDepthCache.clear();
        this.selectedFrame = null;
        this.hoveredFrame = null;
        this.toHighlight = Collections.emptySet();
        this.hoveredSiblingFrames = Collections.emptySet();
        return this;
    }

    @NotNull
    public @NotNull FlamegraphRenderEngine<@NotNull T> reset() {
        this.frameModel = FrameModel.empty();
        this.depth = 1;
        this.visibleDepth = 1;
        this.visibleDepthCache.clear();
        return this;
    }

    public int computeVisibleFlamegraphMinimapHeight(int thumbnailWidth) {
        assert (thumbnailWidth > 0) : "minimap width must be superior to 0";
        return this.visibleDepth * 1;
    }

    public int computeVisibleFlamegraphHeight(@NotNull Graphics2D g2, int canvasWidth) {
        return this.computeVisibleFlamegraphHeight(g2, canvasWidth, false);
    }

    public int computeVisibleFlamegraphHeight(@NotNull Graphics2D g2, int canvasWidth, boolean update) {
        Integer visibleDepth = this.visibleDepthCache.computeIfAbsent(canvasWidth, width -> {
            if (canvasWidth == 0) {
                return 0;
            }
            int vDepth = 0;
            for (FrameBox frame : this.frameModel.frames) {
                if ((double)canvasWidth * (frame.endX - frame.startX) < 2.0) continue;
                vDepth = Math.max(vDepth, frame.stackDepth + 1);
            }
            vDepth = Math.min(vDepth, this.depth);
            return vDepth;
        });
        if (update) {
            this.visibleDepth = visibleDepth;
        }
        return visibleDepth * this.frameRenderer.getFrameBoxHeight(g2);
    }

    public void paint(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Rectangle2D viewRect) {
        this.internalPaint(g2, bounds, viewRect, false, this.icicle);
    }

    public void paintToImage(@NotNull Graphics2D g2, @NotNull Rectangle2D size, boolean icicle) {
        this.internalPaint(g2, size, size, false, icicle);
    }

    public void paintMinimap(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds) {
        this.internalPaint(g2, bounds, bounds, true, this.icicle);
    }

    private void internalPaint(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Rectangle2D viewRect, boolean minimapMode, boolean icicle) {
        if (this.frameModel.frames.isEmpty()) {
            return;
        }
        Objects.requireNonNull(g2);
        Objects.requireNonNull(bounds);
        Objects.requireNonNull(viewRect);
        Graphics2D g2d = (Graphics2D)g2.create();
        this.identifyDisplayScale(g2d);
        int frameBoxHeight = minimapMode ? 1 : this.frameRenderer.getFrameBoxHeight(g2);
        double flameGraphWidth = minimapMode ? viewRect.getWidth() : bounds.getWidth();
        Rectangle2D.Double frameRect = new Rectangle2D.Double();
        List frames = this.frameModel.frames;
        FrameBox rootFrame = frames.get(0);
        int internalPadding = 0;
        frameRect.x = (int)(flameGraphWidth * rootFrame.startX) + internalPadding;
        frameRect.width = (double)((int)(flameGraphWidth * rootFrame.endX)) - frameRect.x - (double)internalPadding;
        frameRect.y = FlamegraphRenderEngine.computeFrameRectY(bounds, frameBoxHeight, rootFrame.stackDepth, icicle);
        frameRect.height = frameBoxHeight;
        Rectangle2D paintableIntersection = viewRect.createIntersection(frameRect);
        if (!paintableIntersection.isEmpty()) {
            this.frameRenderer.paintFrame(g2d, this.frameModel, frameRect, rootFrame, paintableIntersection, FrameRenderingFlags.toFlags(minimapMode, false, false, this.hoveredFrame == rootFrame, false, this.selectedFrame != null, this.selectedFrame == rootFrame, frameRect.getX() == paintableIntersection.getX()));
        }
        for (int i = 1; i < frames.size(); ++i) {
            FrameBox frame = frames.get(i);
            frameRect.x = (int)(flameGraphWidth * frame.startX);
            frameRect.width = (double)((int)(flameGraphWidth * frame.endX)) - frameRect.x;
            if (frameRect.width < 2.0 && !minimapMode) continue;
            frameRect.y = FlamegraphRenderEngine.computeFrameRectY(bounds, frameBoxHeight, frame.stackDepth, icicle);
            frameRect.height = frameBoxHeight;
            paintableIntersection = viewRect.createIntersection(frameRect);
            if (paintableIntersection.isEmpty()) continue;
            this.frameRenderer.paintFrame(g2d, this.frameModel, frameRect, frame, paintableIntersection, FrameRenderingFlags.toFlags(minimapMode, !this.toHighlight.isEmpty(), this.toHighlight.contains(frame), this.hoveredFrame == frame, this.hoveredFrame != frame && this.hoveredSiblingFrames.contains(frame), this.selectedFrame != null, this.selectedFrame != null && frame.stackDepth >= this.selectedFrame.stackDepth && frame.startX >= this.selectedFrame.startX && frame.endX <= this.selectedFrame.endX, frameRect.getX() < paintableIntersection.getX()));
        }
        if (!minimapMode) {
            this.paintHoveredFrameBorder(g2d, bounds, viewRect, flameGraphWidth, frameBoxHeight, frameRect, icicle);
        }
        g2d.dispose();
    }

    private static int computeFrameRectY(@NotNull Rectangle2D bounds, int frameBoxHeight, int stackDepth, boolean icicle) {
        if (icicle) {
            return frameBoxHeight * stackDepth;
        }
        double flamegraphHeight = bounds.getHeight();
        return (int)(flamegraphHeight - (double)frameBoxHeight) - frameBoxHeight * stackDepth;
    }

    private void checkReady() {
        assert (!Objects.equals(this.frameModel, FrameModel.empty())) : "The flamegraph is not initialized, call init(FrameModel) first";
    }

    private void paintHoveredFrameBorder(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Rectangle2D viewRect, double flameGraphWidth, int frameBoxHeight, @NotNull Rectangle2D frameRect, boolean icicle) {
        if (this.hoveredFrame != null) {
            // empty if block
        }
    }

    private void identifyDisplayScale(@NotNull Graphics2D g2) {
        AffineTransform transform = g2.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
    }

    @NotNull
    public Rectangle getFrameRectangle(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull @NotNull FrameBox<@NotNull T> frame) {
        this.checkReady();
        int frameBoxHeight = this.frameRenderer.getFrameBoxHeight(g2);
        int frameGapWidth = this.frameRenderer.getFrameGapWidth();
        Rectangle rect = new Rectangle();
        rect.x = (int)(bounds.getWidth() * frame.startX) - frameGapWidth;
        rect.width = (int)(bounds.getWidth() * frame.endX) - rect.x + 2 * frameGapWidth;
        rect.y = FlamegraphRenderEngine.computeFrameRectY(bounds, frameBoxHeight, frame.stackDepth, this.icicle) - frameGapWidth;
        rect.height = frameBoxHeight + 2 * frameGapWidth;
        return rect;
    }

    public Optional<FrameBox<@NotNull T>> getFrameAt(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Point point) {
        if (this.frameModel.frames.isEmpty()) {
            return Optional.empty();
        }
        int depth = this.computeFrameDepth(g2, bounds, point);
        double xLocation = (double)point.x / bounds.getWidth();
        double visibilityThreshold = 2.0 / bounds.getWidth();
        return this.frameModel.frames.stream().filter(node -> node.stackDepth == depth && node.startX <= xLocation && xLocation <= node.endX && visibilityThreshold < node.endX - node.startX).findFirst();
    }

    private int computeFrameDepth(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Point point) {
        if (this.icicle) {
            return point.y / this.frameRenderer.getFrameBoxHeight(g2);
        }
        return (int)(bounds.getHeight() - (double)point.y) / this.frameRenderer.getFrameBoxHeight(g2);
    }

    public void toggleSelectedFrameAt(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Point point, @NotNull @NotNull BiConsumer<@NotNull FrameBox<@NotNull T>, @NotNull Rectangle> toggleConsumer) {
        this.getFrameAt(g2, bounds, point).ifPresent(frame -> {
            this.selectedFrame = this.selectedFrame == frame ? null : frame;
            toggleConsumer.accept((FrameBox<T>)frame, this.getFrameRectangle(g2, bounds, (FrameBox<T>)frame));
        });
    }

    public void hoverFrame(@NotNull @NotNull FrameBox<@NotNull T> frame, @NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull @NotNull Consumer<@NotNull Rectangle> hoverConsumer) {
        if (this.frameModel.frames.isEmpty()) {
            return;
        }
        FrameBox<T> oldHoveredFrame = this.hoveredFrame;
        if (frame == oldHoveredFrame) {
            return;
        }
        Set<FrameBox<FrameBox>> oldHoveredSiblingFrames = this.hoveredSiblingFrames;
        this.hoveredFrame = frame;
        this.hoveredSiblingFrames = this.getSiblingFrames(frame);
        this.hoveredSiblingFrames.forEach(hovered -> hoverConsumer.accept(this.getFrameRectangle(g2, bounds, (FrameBox<T>)hovered)));
        if (oldHoveredFrame != null) {
            oldHoveredSiblingFrames.forEach(hovered -> hoverConsumer.accept(this.getFrameRectangle(g2, bounds, (FrameBox<T>)hovered)));
        }
    }

    public void stopHover(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull @NotNull Consumer<@NotNull Rectangle> hoverConsumer) {
        if (this.frameModel.frames.isEmpty()) {
            return;
        }
        FrameBox<T> oldHoveredFrame = this.hoveredFrame;
        Set<FrameBox<FrameBox>> oldHoveredSiblingFrame = this.hoveredSiblingFrames;
        this.hoveredFrame = null;
        this.hoveredSiblingFrames = Collections.emptySet();
        if (oldHoveredFrame != null) {
            oldHoveredSiblingFrame.forEach(hovered -> hoverConsumer.accept(this.getFrameRectangle(g2, bounds, (FrameBox<T>)hovered)));
        }
    }

    @NotNull
    private @NotNull Set<@NotNull FrameBox<@NotNull T>> getSiblingFrames(@NotNull @NotNull FrameBox<@NotNull T> frame) {
        if (!this.showHoveredSiblings) {
            return Set.of(frame);
        }
        return this.frameModel.frames.stream().filter(node -> this.frameModel.frameEquality.equal(node, frame)).collect(Collectors.toSet());
    }

    public Optional<ZoomTarget<@NotNull T>> calculateZoomTargetForFrameAt(Graphics2D g2, Rectangle2D bounds, Rectangle2D viewRect, Point point) {
        if (this.frameModel.frames.isEmpty()) {
            return Optional.empty();
        }
        return this.getFrameAt(g2, bounds, point).map(frame -> {
            this.selectedFrame = frame;
            return this.calculateZoomTargetFrame(g2, bounds, viewRect, (FrameBox<T>)frame, 0, 0);
        });
    }

    @ApiStatus.Experimental
    @NotNull
    public @NotNull ZoomTarget<@NotNull T> calculateZoomTargetFrame(@NotNull Graphics2D g2, @NotNull Rectangle2D bounds, @NotNull Rectangle2D viewRect, @NotNull @NotNull FrameBox<@NotNull T> frame, int contextBefore, int contextLeftRight) {
        this.checkReady();
        double frameWidthX = frame.endX - frame.startX;
        int frameBoxHeight = this.frameRenderer.getFrameBoxHeight(g2);
        double factor = FlamegraphRenderEngine.getScaleFactor(viewRect.getWidth(), bounds.getWidth(), frameWidthX);
        int newCanvasWidth = (int)(bounds.getWidth() * factor);
        int newCanvasHeight = this.computeVisibleFlamegraphHeight(g2, newCanvasWidth);
        Rectangle2D.Double newDimension = new Rectangle2D.Double(bounds.getX(), bounds.getY(), newCanvasWidth, newCanvasHeight);
        int frameY = FlamegraphRenderEngine.computeFrameRectY(newDimension, frameBoxHeight, Math.max(frame.stackDepth - contextBefore, 0), this.icicle);
        int viewLocationY = this.icicle ? Math.max(0, frameY) : Math.min((int)((double)newCanvasHeight - viewRect.getHeight()), (int)((double)(frameY + frameBoxHeight) - viewRect.getHeight()));
        return new ZoomTarget<T>(-((int)(frame.startX * (double)newCanvasWidth)), -viewLocationY, newCanvasWidth, newCanvasHeight, frame);
    }

    protected static double getScaleFactor(double visibleWidth, double canvasWidth, double frameWidthX) {
        return visibleWidth / (canvasWidth * frameWidthX);
    }

    public void setHighlightFrames(@NotNull @NotNull Set<@NotNull FrameBox<@NotNull T>> toHighlight, @Nullable String searchedText) {
        this.toHighlight = Objects.requireNonNull(toHighlight);
    }

    public void setShowHoveredSiblings(boolean showHoveredSiblings) {
        this.showHoveredSiblings = showHoveredSiblings;
    }

    public boolean isShowHoveredSiblings() {
        return this.showHoveredSiblings;
    }

    @NotNull
    public @NotNull FrameRenderer<@NotNull T> getFrameRenderer() {
        return this.frameRenderer;
    }

    public void setIcicle(boolean icicle) {
        this.icicle = icicle;
    }

    public boolean isIcicle() {
        return this.icicle;
    }

    @NotNull
    public @NotNull FrameModel<@NotNull T> getFrameModel() {
        return this.frameModel;
    }
}

