/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.raweditor.internal;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.openjdk.jmc.console.agent.raweditor.internal.ColorManager;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlConfiguration;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlDocumentProvider;

public class XmlEditor
extends TextEditor {
    private ColorManager colorManager = new ColorManager();

    public XmlEditor() {
        this.setSourceViewerConfiguration(new XmlConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new XmlDocumentProvider());
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        input = XmlEditor.convertInput(input);
        super.doSetInput(input);
        this.setDocumentProvider(input);
    }

    protected void createActions() {
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public static IEditorInput convertInput(final IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput || editorInput instanceof IStorageEditorInput) {
            return editorInput;
        }
        if (editorInput instanceof IPathEditorInput) {
            final IPath p = ((IPathEditorInput)editorInput).getPath();
            LocalFileStorage s = new LocalFileStorage(p.toFile()){

                public boolean isReadOnly() {
                    return false;
                }
            };
            return new IStorageEditorInput((IStorage)s){
                private final /* synthetic */ IStorage val$s;
                {
                    this.val$s = iStorage;
                }

                public <T> T getAdapter(Class<T> adapter) {
                    if (adapter.equals(ILocationProvider.class)) {
                        return (T)((ILocationProvider)element -> p);
                    }
                    return (T)editorInput.getAdapter(adapter);
                }

                public boolean exists() {
                    return editorInput.exists();
                }

                public ImageDescriptor getImageDescriptor() {
                    return editorInput.getImageDescriptor();
                }

                public String getName() {
                    return editorInput.getName();
                }

                public IPersistableElement getPersistable() {
                    return editorInput.getPersistable();
                }

                public String getToolTipText() {
                    return editorInput.getToolTipText();
                }

                public IStorage getStorage() {
                    return this.val$s;
                }
            };
        }
        throw new UnsupportedOperationException();
    }
}

