/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.scripting.actions;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.rcp.application.scripting.actions.ProcessAction;
import org.openjdk.jmc.rcp.application.scripting.model.OperatingSystem;
import org.openjdk.jmc.ui.UIPlugin;

public final class LoadAction
extends ProcessAction {
    private final StyledText m_styleText;

    public LoadAction(StyledText s, OperatingSystem os) {
        super(os, "Load", 1);
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("import.gif"));
        this.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("import.gif"));
        this.m_styleText = s;
    }

    @Override
    public void run() {
        FileDialog fileDialog = new FileDialog(this.m_styleText.getShell(), 4096);
        fileDialog.setFilterNames(new String[]{"Mission Control Script File (*.mcs)"});
        fileDialog.setFilterExtensions(new String[]{"*.mcs"});
        fileDialog.setFilterIndex(0);
        fileDialog.setFileName("*.mcs");
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.load(fileName);
        }
    }

    private void load(String fileName) {
        try {
            List sourceCode = IOToolkit.loadFromFile((File)new File(fileName));
            this.m_styleText.setText("");
            this.m_styleText.setStyleRanges(new StyleRange[0]);
            StringBuffer s = new StringBuffer();
            for (String line : sourceCode) {
                s.append(line);
                s.append('\r');
            }
            this.m_styleText.append(s.toString());
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.m_styleText.getShell(), (String)"Error loading program", (String)e.getMessage());
        }
    }

    @Override
    protected void updateStatus() {
        this.setEnabled(!this.getProcess().isRunning());
    }
}

