/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.scripting.actions;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.rcp.application.scripting.actions.ProcessAction;
import org.openjdk.jmc.rcp.application.scripting.model.OperatingSystem;
import org.openjdk.jmc.ui.UIPlugin;

public class SaveAction
extends ProcessAction {
    private final Shell m_shell;

    public SaveAction(Shell shell, OperatingSystem os) {
        super(os, "Save", 1);
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("export.gif"));
        this.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("export.gif"));
        this.m_shell = shell;
    }

    @Override
    public void run() {
        FileDialog file = new FileDialog(this.m_shell, 8192);
        file.setFilterNames(new String[]{"Mission Control Script File (*.mcs)"});
        file.setFilterExtensions(new String[]{"*.mcs"});
        file.setFileName("script.mcs");
        String fileName = file.open();
        try {
            List<String> sourceCodeList = this.getProcess().getProgram().getSourceLines();
            IOToolkit.saveToFile((File)new File(fileName), sourceCodeList);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.m_shell, (String)"Error loading program", (String)e.getMessage());
        }
    }

    @Override
    protected void updateStatus() {
    }
}

