/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.server.core.backend.Config;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;

public class DebugStore
extends AbstractJolokiaService<JolokiaService.Init> {
    private final LinkedList<Entry> debugEntries = new LinkedList();
    private ObjectName debugStoreObjectName;
    private int maxDebugEntries;
    private boolean isDebug;

    public DebugStore() {
        super(JolokiaService.Init.class, 0);
    }

    public DebugStore(int maxDebugEntries, boolean isDebug) {
        super(JolokiaService.Init.class, 0);
        this.maxDebugEntries = maxDebugEntries;
        this.isDebug = isDebug;
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
        super.init(pJolokiaContext);
        AgentDetails details = pJolokiaContext.getAgentDetails();
        String agentId = details.getAgentId();
        String oName = "jolokia:type=Config,agent=" + agentId;
        this.maxDebugEntries = Integer.parseInt(pJolokiaContext.getConfig(ConfigKey.DEBUG_MAX_ENTRIES));
        this.isDebug = Boolean.parseBoolean(pJolokiaContext.getConfig(ConfigKey.DEBUG));
        Config config = new Config(this, oName);
        try {
            this.debugStoreObjectName = new ObjectName(oName);
            pJolokiaContext.registerMBean(config, oName);
        }
        catch (MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            pJolokiaContext.error("Problem registering " + oName + " MBean", e);
        }
        catch (InstanceAlreadyExistsException e) {
            pJolokiaContext.info(oName + " MBean is already registered");
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.debugStoreObjectName != null) {
            this.getJolokiaContext().unregisterMBean(this.debugStoreObjectName);
            this.debugStoreObjectName = null;
        }
    }

    public void log(String pMessage) {
        if (!this.isDebug) {
            return;
        }
        this.add(System.currentTimeMillis() / 1000L, pMessage);
    }

    public void log(String pMessage, Throwable pThrowable) {
        this.add(System.currentTimeMillis() / 1000L, pMessage, pThrowable);
    }

    public String debugInfo() {
        if (!this.isDebug || this.debugEntries.isEmpty()) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = this.debugEntries.size() - 1; i >= 0; --i) {
            Entry entry = this.debugEntries.get(i);
            ret.append(entry.timestamp).append(": ").append(entry.message).append("\n");
            if (entry.throwable == null) continue;
            StringWriter writer = new StringWriter();
            entry.throwable.printStackTrace(new PrintWriter(writer));
            ret.append(writer);
        }
        return ret.toString();
    }

    public void resetDebugInfo() {
        this.debugEntries.clear();
    }

    public void setDebug(boolean pSwitch) {
        if (!pSwitch) {
            this.resetDebugInfo();
        }
        this.isDebug = pSwitch;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public int getMaxDebugEntries() {
        return this.maxDebugEntries;
    }

    public void setMaxDebugEntries(int pNumber) {
        this.maxDebugEntries = pNumber;
        this.trim();
    }

    private synchronized void add(long pTime, String message) {
        this.debugEntries.addFirst(new Entry(pTime, message));
        this.trim();
    }

    private synchronized void add(long pTimestamp, String pMessage, Throwable pThrowable) {
        this.debugEntries.addFirst(new Entry(pTimestamp, pMessage, pThrowable));
        this.trim();
    }

    private synchronized void trim() {
        while (this.debugEntries.size() > this.maxDebugEntries) {
            this.debugEntries.removeLast();
        }
    }

    private static final class Entry {
        private final long timestamp;
        private final String message;
        private Throwable throwable;

        private Entry(long pTimestamp, String pMessage, Throwable pThrowable) {
            this.timestamp = pTimestamp;
            this.message = pMessage;
            this.throwable = pThrowable;
        }

        private Entry(long pTime, String pMessage) {
            this.timestamp = pTime;
            this.message = pMessage;
        }
    }
}

