/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jdp.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.jdp.client.Discoverable;
import org.openjdk.jmc.jdp.common.CodingException;
import org.openjdk.jmc.jdp.common.JRockitJDPPacketDecoder;

public final class JDPPacket
implements Discoverable {
    static final String KEY_DISCOVERABLE_ID = "DISCOVERABLE_SESSION_UUID";
    private static final int PROTOCOL_VERSION = 1;
    private static final byte[] MAGIC = new byte[]{-64, -1, -18, 66};
    private final Map<String, String> decoded;
    private final byte[] encoded;
    private final String sessionId;

    public JDPPacket(Map<String, String> discoveryData) {
        this.decoded = discoveryData;
        this.encoded = JDPPacket.encode(discoveryData);
        this.sessionId = this.decoded.get(KEY_DISCOVERABLE_ID);
    }

    public JDPPacket(byte[] data) throws CodingException {
        this.decoded = JDPPacket.decode(data);
        this.encoded = data;
        this.sessionId = this.decoded.get(KEY_DISCOVERABLE_ID);
    }

    @Override
    public Map<String, String> getPayload() {
        return this.decoded;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public byte[] getDiscoveryDataAsByteArray() {
        return this.encoded;
    }

    private static byte[] encode(Map<String, String> discoveryData) throws CodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.write(MAGIC);
            dos.writeShort(1);
            for (Map.Entry<String, String> entry : discoveryData.entrySet()) {
                if (entry.getValue() == null) continue;
                dos.writeUTF(entry.getKey());
                dos.writeUTF(entry.getValue());
            }
        }
        catch (IOException e) {
            throw new CodingException("Problem encoding JDP packet!", e);
        }
        return baos.toByteArray();
    }

    private static Map<String, String> decode(byte[] data) throws CodingException {
        if (data.length < 6) {
            throw new CodingException("Corrupt packet! Length was " + data.length);
        }
        if (JDPPacket.checkMagic(data)) {
            try {
                return JDPPacket.decodeHotSpot(data);
            }
            catch (IOException e) {
                throw new CodingException("Problem decoding JDP packet!", e);
            }
        }
        if (JRockitJDPPacketDecoder.checkJRockitJDP(data)) {
            return JRockitJDPPacketDecoder.decodeJRockitJDP(data);
        }
        throw new CodingException("Packet does not start with JDP magic!");
    }

    private static Map<String, String> decodeHotSpot(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dis.readInt();
        JDPPacket.checkVersion(dis.readUnsignedShort());
        if (dis.available() == 0) {
            return dataMap;
        }
        String value = null;
        try {
            while (true) {
                String key = JDPPacket.decodeString(dis);
                value = JDPPacket.decodeString(dis);
                dataMap.put(key, value);
            }
        }
        catch (EOFException e) {
            if (value == null) {
                throw new IOException("Problem decoding JDP packet!", e);
            }
            return dataMap;
        }
    }

    private static String decodeString(DataInputStream dis) throws IOException {
        int length = dis.readUnsignedShort();
        if (length > dis.available()) {
            throw new CodingException("Discovered corrupt JDP packet!");
        }
        byte[] buf = new byte[length];
        if (dis.read(buf) != length) {
            throw new IOException("Problem decoding string!");
        }
        return new String(buf, StandardCharsets.UTF_8);
    }

    private static boolean checkMagic(byte[] data) {
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == data[i]) continue;
            return false;
        }
        return true;
    }

    private static void checkVersion(int version) throws CodingException {
        if (1 != version) {
            throw new CodingException(String.format("Found JDP packet with unsupported version. Version found was %d.", version));
        }
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDPPacket other = (JDPPacket)obj;
        if (!this.sessionId.equals(other.sessionId)) {
            return false;
        }
        return this.decoded.equals(other.decoded);
    }

    public String toString() {
        return String.format("JDPPacket(%s): (%s)", this.sessionId, this.decoded);
    }
}

