/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jolokia;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.Optional;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.openmbean.TabularData;
import org.jolokia.client.J4pClient;
import org.jolokia.client.jmxadapter.RemoteJmxAdapter;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.service.serializer.JolokiaSerializer;

public class JmcJolokiaJmxConnection
extends RemoteJmxAdapter {
    private static final String UNKNOWN = "Unknown";
    private static final String DIAGNOSTIC_OPTIONS = "com.sun.management:type=DiagnosticCommand";
    private static final String PREFIX = "dcmd.";
    private static final String IMPACT = "dcmd.vmImpact";
    private static final String NAME = "dcmd.name";
    private static final String DESCRIPTION = "dcmd.description";
    private static final String ARGUMENTS = "dcmd.arguments";
    private static final String ARGUMENT_NAME = "dcmd.arg.name";
    private static final String ARGUMENT_DESCRIPTION = "dcmd.arg.description";
    private static final String ARGUMENT_MANDATORY = "dcmd.arg.isMandatory";
    private static final String ARGUMENT_TYPE = "dcmd.arg.type";
    private static final String ARGUMENT_OPTION = "dcmd.arg.isOption";
    private static final String ARGUMENT_MULITPLE = "dcmd.arg.isMultiple";

    public JmcJolokiaJmxConnection(J4pClient client) throws IOException {
        super(client);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IOException {
        MBeanInfo mBeanInfo = super.getMBeanInfo(name);
        if (DIAGNOSTIC_OPTIONS.equals(name.getCanonicalName()) && mBeanInfo.getOperations()[0].getDescriptor() == ImmutableDescriptor.EMPTY_DESCRIPTOR) {
            MBeanOperationInfo[] modifiedOperations = new MBeanOperationInfo[mBeanInfo.getOperations().length];
            int i = 0;
            while (i < mBeanInfo.getOperations().length) {
                modifiedOperations[i] = this.stealOrBuildOperationInfo(mBeanInfo.getOperations()[i], this.checkForLocalOperationInfo(name));
                ++i;
            }
            MBeanInfo modifiedMBeanInfo = new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanInfo.getAttributes(), mBeanInfo.getConstructors(), modifiedOperations, mBeanInfo.getNotifications());
            this.mbeanInfoCache.put(name, modifiedMBeanInfo);
            return modifiedMBeanInfo;
        }
        return mBeanInfo;
    }

    private Optional<MBeanInfo> checkForLocalOperationInfo(ObjectName name) {
        MBeanInfo localInfo;
        try {
            localInfo = ManagementFactory.getPlatformMBeanServer().getMBeanInfo(name);
        }
        catch (Exception | NoClassDefFoundError throwable) {
            localInfo = null;
        }
        return Optional.ofNullable(localInfo);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, IOException {
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                Object object = params[i];
                if (object instanceof TabularData) {
                    try {
                        params[i] = new JolokiaSerializer().serialize(object, new LinkedList(), SerializeOptions.DEFAULT);
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {}
                }
                ++i;
            }
        }
        return super.invoke(name, operationName, params, signature);
    }

    private MBeanOperationInfo stealOrBuildOperationInfo(MBeanOperationInfo original, Optional<MBeanInfo> localInfo) {
        return localInfo.map(info -> this.checkForMatchingLocalOperation(original, (MBeanInfo)info)).orElseGet(() -> this.reverseEngineerOperationInfo(original));
    }

    private MBeanOperationInfo checkForMatchingLocalOperation(MBeanOperationInfo original, MBeanInfo info) {
        MBeanOperationInfo[] mBeanOperationInfoArray = info.getOperations();
        int n = mBeanOperationInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo localOperation = mBeanOperationInfoArray[n2];
            if (localOperation.getName().equals(original.getName()) && localOperation.getSignature().length == original.getSignature().length) {
                int i = 0;
                while (i < original.getSignature().length) {
                    MBeanParameterInfo param = original.getSignature()[i];
                    if (!param.getType().equals(localOperation.getSignature()[i].getType())) break;
                    if (i == original.getSignature().length - 1) {
                        return localOperation;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return null;
    }

    private MBeanOperationInfo reverseEngineerOperationInfo(MBeanOperationInfo original) {
        DescriptorSupport result = new DescriptorSupport();
        result.setField(NAME, original.getName());
        result.setField(DESCRIPTION, original.getDescription());
        result.setField(IMPACT, UNKNOWN);
        result.setField(ARGUMENTS, this.buildArguments(original.getSignature()));
        return new MBeanOperationInfo(original.getName(), original.getDescription(), original.getSignature(), original.getReturnType(), 3, result);
    }

    private Descriptor buildArguments(MBeanParameterInfo[] signature) {
        DescriptorSupport parameters = new DescriptorSupport();
        MBeanParameterInfo[] mBeanParameterInfoArray = signature;
        int n = signature.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo parameter = mBeanParameterInfoArray[n2];
            parameters.setField(parameter.getName(), this.buildArgument(parameter));
            ++n2;
        }
        return parameters;
    }

    private Descriptor buildArgument(MBeanParameterInfo parameter) {
        DescriptorSupport result = new DescriptorSupport();
        result.setField(ARGUMENT_NAME, parameter.getName());
        boolean isMultiple = parameter.getType().startsWith("[");
        result.setField(ARGUMENT_MULITPLE, String.valueOf(isMultiple));
        String type = parameter.getType();
        if (isMultiple) {
            type = type.startsWith("[L") ? type.substring(2) : type.substring(1);
        }
        result.setField(ARGUMENT_TYPE, type);
        result.setField(ARGUMENT_DESCRIPTION, parameter.getDescription());
        result.setField(ARGUMENT_MANDATORY, "false");
        result.setField(ARGUMENT_OPTION, "false");
        return result;
    }

    public boolean isInstanceOf(ObjectName objectName, String type) throws InstanceNotFoundException, IOException {
        if ("java.lang.management.OperatingSystemMXBean".equals(type) && "com.sun.management.internal.OperatingSystemImpl".equals(this.getMBeanInfo(objectName).getClassName())) {
            return true;
        }
        try {
            return super.isInstanceOf(objectName, type);
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError linkageError) {
            return false;
        }
    }
}

