/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.SimpleConstrainedMap;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.configuration.ConfigurationToolkit;
import org.openjdk.jmc.flightrecorder.configuration.FlightRecorderException;
import org.openjdk.jmc.flightrecorder.configuration.IFlightRecorderService;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.flightrecorder.configuration.OptionInfo;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeInfo;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.configuration.internal.DefaultValueMap;
import org.openjdk.jmc.flightrecorder.configuration.internal.EventTypeIDV1;
import org.openjdk.jmc.flightrecorder.configuration.internal.IMapper;
import org.openjdk.jmc.flightrecorder.configuration.internal.KnownRecordingOptions;
import org.openjdk.jmc.flightrecorder.configuration.internal.ValidationToolkit;
import org.openjdk.jmc.rjmx.common.ConnectionException;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.common.services.ICommercialFeaturesService;
import org.openjdk.jmc.rjmx.common.services.jfr.FlightRecorderToolkit;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.EventOptionsToolkitV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.EventTypeMetadataV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.FlightRecorderCommunicationHelperV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.IFlightRecorderCommunicationHelper;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.JfrRecordingInputStreamV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.RecordingDescriptorToolkitV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.RecordingOptionsToolkitV1;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.RecordingTemplateToolkit;
import org.openjdk.jmc.rjmx.common.subscription.IMBeanHelperService;

public class FlightRecorderServiceV1
implements IFlightRecorderService {
    static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.common.services.jfr");
    private static final IMapper<EventOptionID, IOptionDescriptor<?>> DISALLOW_MAPPER = new IMapper<EventOptionID, IOptionDescriptor<?>>(){

        public IOptionDescriptor<?> get(EventOptionID key) {
            return OptionInfo.DISALLOWED_OPTION;
        }
    };
    private static final ITypedQuantity<LinearUnit> MAX_REQUIRED_RECORDING_DURATION = UnitLookup.YEAR.quantity(10L);
    private final IFlightRecorderCommunicationHelper helper;
    private long eventTypeMetaNextUpdate;
    private List<EventTypeMetadataV1> eventTypeMetas;
    private Map<Integer, EventTypeMetadataV1> eventTypeMetaByInt;
    private Map<EventTypeIDV1, EventTypeMetadataV1> eventTypeInfoById;
    private boolean wasEnabled;
    private final ICommercialFeaturesService cfs;
    private final IMBeanHelperService mbhs;
    private final String serverId;

    public String getVersion() {
        return "1.0";
    }

    private boolean isDynamicFlightRecorderSupported(IConnectionHandle handle) {
        return ConnectionToolkit.isHotSpot(handle) && ConnectionToolkit.isJavaVersionAboveOrEqual(handle, JavaVersionSupport.DYNAMIC_JFR_SUPPORTED);
    }

    private boolean isFlightRecorderDisabled(IConnectionHandle handle) {
        if (this.cfs != null) {
            return !this.cfs.isCommercialFeaturesEnabled() || ConnectionToolkit.isFlightRecorderDisabled(handle, false);
        }
        return true;
    }

    public FlightRecorderServiceV1(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        this.cfs = handle.getServiceOrThrow(ICommercialFeaturesService.class);
        if (!ConnectionToolkit.hasFlightRecorder(handle)) {
            throw new ServiceNotAvailableException("");
        }
        if (!this.isDynamicFlightRecorderSupported(handle) && this.isFlightRecorderDisabled(handle)) {
            throw new ServiceNotAvailableException("");
        }
        if (ConnectionToolkit.isFlightRecorderDisabled(handle, true)) {
            throw new ServiceNotAvailableException("");
        }
        this.helper = new FlightRecorderCommunicationHelperV1(handle.getServiceOrThrow(MBeanServerConnection.class));
        this.mbhs = handle.getServiceOrThrow(IMBeanHelperService.class);
        this.serverId = handle.getServerDescriptor().getGUID();
    }

    public void stop(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.stop(descriptor.getObjectName());
    }

    private void stop(ObjectName objectName) throws FlightRecorderException {
        try {
            this.helper.invokeOperation("stop", objectName);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not stop the recording!", (Throwable)e);
        }
    }

    public void close(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.helper.closeRecording(descriptor);
    }

    public IRecordingDescriptor start(IConstrainedMap<String> recordingOptions, IConstrainedMap<EventOptionID> eventOptions) throws FlightRecorderException {
        try {
            this.validateOptions(recordingOptions);
            String name = RecordingOptionsToolkitV1.getName(recordingOptions);
            ObjectName recording = (ObjectName)this.helper.invokeOperation("createRecording", name);
            this.helper.invokeOperation("setRecordingOptions", recording, RecordingOptionsToolkitV1.getRecordingOptions(recordingOptions));
            if (eventOptions != null) {
                this.updateEventOptions(recording, eventOptions);
            }
            this.helper.invokeOperation("start", recording);
            for (IRecordingDescriptor descriptor : this.getAvailableRecordings()) {
                if (!recording.equals(descriptor.getObjectName())) continue;
                return descriptor;
            }
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not start the recording!", (Throwable)e);
        }
        return null;
    }

    public IDescribedMap<String> getDefaultRecordingOptions() {
        return KnownRecordingOptions.OPTION_DEFAULTS_V1;
    }

    public IConstrainedMap<String> getRecordingOptions(IRecordingDescriptor recording) throws FlightRecorderException {
        try {
            return this.getRecordingOptions(recording.getObjectName());
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not retrieve recording options.", (Throwable)e);
        }
    }

    private IConstrainedMap<String> getRecordingOptions(ObjectName name) throws FlightRecorderException, IOException {
        return RecordingOptionsToolkitV1.toRecordingOptions((CompositeData)this.helper.invokeOperation("getRecordingOptions", name));
    }

    public IConstrainedMap<EventOptionID> getEventSettings(IRecordingDescriptor recording) throws FlightRecorderException {
        try {
            Map<Integer, EventTypeMetadataV1> map = this.getEventTypeByIntMap();
            List compositeList = (List)this.helper.invokeOperation("getEventSettings", recording.getObjectName());
            return FlightRecorderServiceV1.toEventOptionMap(map, compositeList);
        }
        catch (Exception e) {
            FlightRecorderException flr = new FlightRecorderException("Could not retrieve recording options for recording " + recording.getName() + ".");
            flr.initCause((Throwable)e);
            throw flr;
        }
    }

    public Map<String, IOptionDescriptor<?>> getAvailableRecordingOptions() throws FlightRecorderException {
        return RecordingOptionsToolkitV1.getAvailableRecordingOptions();
    }

    public String toString() {
        return this.helper.toString();
    }

    public InputStream openStream(IRecordingDescriptor descriptor, boolean removeOnClose) throws FlightRecorderException {
        IRecordingDescriptor streamDescriptor = descriptor;
        boolean clone = this.isStillRunning(descriptor);
        if (clone) {
            streamDescriptor = this.clone(descriptor);
        }
        return new JfrRecordingInputStreamV1(this.helper, streamDescriptor, clone | removeOnClose);
    }

    public InputStream openStream(IRecordingDescriptor descriptor, IQuantity startTime, IQuantity endTime, boolean removeOnClose) throws FlightRecorderException {
        IRecordingDescriptor streamDescriptor = descriptor;
        boolean clone = this.isStillRunning(descriptor);
        if (clone) {
            streamDescriptor = this.clone(descriptor);
        }
        return new JfrRecordingInputStreamV1(this.helper, streamDescriptor, UnitLookup.toDate((IQuantity)startTime), UnitLookup.toDate((IQuantity)endTime), clone | removeOnClose);
    }

    public Collection<EventTypeMetadataV1> getAvailableEventTypes() throws FlightRecorderException {
        return this.updateEventTypeMetadataMaps(true);
    }

    public List<IRecordingDescriptor> getAvailableRecordings() throws FlightRecorderException {
        List attribute = (List)this.helper.getAttribute("Recordings");
        ArrayList<IRecordingDescriptor> recordings = new ArrayList<IRecordingDescriptor>();
        for (CompositeData data : attribute) {
            recordings.add(RecordingDescriptorToolkitV1.createRecordingDescriptor(this.serverId, data));
        }
        return Collections.unmodifiableList(recordings);
    }

    public IRecordingDescriptor getSnapshotRecording() throws FlightRecorderException {
        return FlightRecorderToolkit.getDescriptorByTimerange(this.getAvailableRecordings(), MAX_REQUIRED_RECORDING_DURATION);
    }

    public IConstrainedMap<EventOptionID> getCurrentEventTypeSettings() throws FlightRecorderException {
        Map<Integer, EventTypeMetadataV1> byIntMap = this.getEventTypeByIntMap();
        List compositeList = (List)this.helper.getAttribute("EventSettings");
        return FlightRecorderServiceV1.toEventOptionMap(byIntMap, compositeList);
    }

    public IDescribedMap<EventOptionID> getDefaultEventOptions() {
        try {
            this.updateEventTypeMetadataMaps(true);
            HashMap optionInfoById = new HashMap();
            for (Map.Entry<EventTypeIDV1, EventTypeMetadataV1> typeEntry : this.eventTypeInfoById.entrySet()) {
                for (Map.Entry<String, IOptionDescriptor<?>> optionEntry : typeEntry.getValue().getOptionDescriptors().entrySet()) {
                    EventOptionID optionID = new EventOptionID((IEventTypeID)typeEntry.getKey(), optionEntry.getKey());
                    optionInfoById.put(optionID, optionEntry.getValue());
                }
            }
            return new DefaultValueMap(optionInfoById, DISALLOW_MAPPER);
        }
        catch (FlightRecorderException e) {
            LOGGER.log(Level.WARNING, "Couldn't get default event options", e);
            return ConfigurationToolkit.getEventOptions((SchemaVersion)SchemaVersion.V1);
        }
    }

    public IRecordingDescriptor getUpdatedRecordingDescription(IRecordingDescriptor descriptor) throws FlightRecorderException {
        return this.getUpdatedRecordingDescriptor(descriptor.getObjectName());
    }

    public List<String> getServerTemplates() throws FlightRecorderException {
        List compositeData = (List)this.helper.getAttribute("AvailablePresets");
        return RecordingTemplateToolkit.getServerTemplatesV1(compositeData);
    }

    public void updateEventOptions(IRecordingDescriptor descriptor, IConstrainedMap<EventOptionID> options) throws FlightRecorderException {
        try {
            this.updateEventOptions(descriptor.getObjectName(), options);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed updating the event options for " + descriptor.getName(), (Throwable)e);
        }
    }

    private IRecordingDescriptor getUpdatedRecordingDescriptor(ObjectName name) throws FlightRecorderException {
        return RecordingDescriptorToolkitV1.getRecordingByDescriptor(name, this.getAvailableRecordings());
    }

    private void validateOptions(IConstrainedMap<String> recordingOptions) throws FlightRecorderException {
        try {
            ValidationToolkit.validate(recordingOptions);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not validate options!\n" + e.getMessage());
        }
    }

    public Map<? extends IEventTypeID, ? extends IEventTypeInfo> getEventTypeInfoMapByID() throws FlightRecorderException {
        this.updateEventTypeMetadataMaps(false);
        return this.eventTypeInfoById;
    }

    private Map<Integer, EventTypeMetadataV1> getEventTypeByIntMap() throws FlightRecorderException {
        this.updateEventTypeMetadataMaps(false);
        return this.eventTypeMetaByInt;
    }

    private Collection<EventTypeMetadataV1> updateEventTypeMetadataMaps(boolean force) throws FlightRecorderException {
        long timestamp = System.currentTimeMillis();
        if (force || timestamp > this.eventTypeMetaNextUpdate) {
            List compositeList = (List)this.helper.getAttribute("EventDescriptors");
            ArrayList<EventTypeMetadataV1> metadataList = new ArrayList<EventTypeMetadataV1>(compositeList.size());
            HashMap<Integer, EventTypeMetadataV1> byInt = new HashMap<Integer, EventTypeMetadataV1>();
            HashMap<EventTypeIDV1, EventTypeMetadataV1> byId = new HashMap<EventTypeIDV1, EventTypeMetadataV1>();
            for (CompositeData data : compositeList) {
                try {
                    EventTypeMetadataV1 element = FlightRecorderServiceV1.toEventMetaDataV1(data);
                    metadataList.add(element);
                    byInt.put(element.getId(), element);
                    byId.put(element.getEventTypeID(), element);
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.WARNING, "Could not create event metadata for composite data!", e);
                }
            }
            this.eventTypeMetaNextUpdate = timestamp + 60000L;
            this.eventTypeMetas = Collections.unmodifiableList(metadataList);
            this.eventTypeMetaByInt = Collections.unmodifiableMap(byInt);
            this.eventTypeInfoById = Collections.unmodifiableMap(byId);
        }
        return this.eventTypeMetas;
    }

    private boolean isStillRunning(IRecordingDescriptor descriptor) throws FlightRecorderException {
        IRecordingDescriptor updatedDescriptor = this.getUpdatedRecordingDescription(descriptor);
        return updatedDescriptor != null && IRecordingDescriptor.RecordingState.RUNNING.equals((Object)updatedDescriptor.getState());
    }

    private IRecordingDescriptor clone(IRecordingDescriptor descriptor) throws FlightRecorderException {
        try {
            ObjectName name = (ObjectName)this.helper.invokeOperation("cloneRecording", descriptor.getObjectName(), "Clone of " + descriptor.getName(), Boolean.TRUE);
            return this.getUpdatedRecordingDescriptor(name);
        }
        catch (IOException e) {
            throw new FlightRecorderException("Could not clone the " + descriptor.getName() + " recording ", (Throwable)e);
        }
    }

    private void updateEventOptions(ObjectName recording, IConstrainedMap<EventOptionID> eventOptions) throws OpenDataException, IOException, FlightRecorderException {
        this.helper.invokeOperation("updateEventSettings", recording, EventOptionsToolkitV1.encodeAllEventSettings(this.getAvailableEventTypes(), eventOptions));
    }

    public void updateRecordingOptions(IRecordingDescriptor descriptor, IConstrainedMap<String> options) throws FlightRecorderException {
        this.validateOptions(options);
        try {
            this.helper.invokeOperation("setRecordingOptions", descriptor.getObjectName(), RecordingOptionsToolkitV1.getRecordingOptions(options));
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed updating the recording options for " + descriptor.getName(), (Throwable)e);
        }
    }

    public InputStream openStream(IRecordingDescriptor descriptor, IQuantity lastPartDuration, boolean removeOnClose) throws FlightRecorderException {
        long serverTime = this.mbhs.getApproximateServerTime(System.currentTimeMillis());
        ITypedQuantity endDate = UnitLookup.EPOCH_MS.quantity(serverTime);
        IQuantity startDate = endDate.subtract(lastPartDuration);
        return this.openStream(descriptor, startDate, (IQuantity)endDate, removeOnClose);
    }

    public boolean isEnabled() {
        if (!this.wasEnabled) {
            boolean isEnabled = this.cfs.isCommercialFeaturesEnabled();
            if (isEnabled) {
                this.wasEnabled = true;
            }
            return isEnabled;
        }
        return this.wasEnabled;
    }

    public void enable() throws FlightRecorderException {
        try {
            this.cfs.enableCommercialFeatures();
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed to enable commercial features", (Throwable)e);
        }
    }

    private static IConstrainedMap<EventOptionID> toEventOptionMap(Map<Integer, EventTypeMetadataV1> typeByInt, List<CompositeData> compositeDatas) {
        SimpleConstrainedMap options = new SimpleConstrainedMap();
        for (CompositeData data : compositeDatas) {
            Integer intID = (Integer)data.get("id");
            EventTypeMetadataV1 metadata = typeByInt.get(intID);
            EventOptionsToolkitV1.addOptionsToV1((IMutableConstrainedMap<EventOptionID>)options, metadata, data);
        }
        return options;
    }

    public static EventTypeMetadataV1 toEventMetaDataV1(CompositeData data) throws URISyntaxException {
        String uri = (String)data.get("uri");
        Integer id = (Integer)data.get("id");
        String path = (String)data.get("path");
        String label = (String)data.get("name");
        String description = (String)data.get("description");
        new URI(uri);
        assert (uri.endsWith(path));
        EventTypeIDV1 eventTypeID = new EventTypeIDV1(uri, uri.length() - path.length());
        return new EventTypeMetadataV1(id, eventTypeID, label, description, EventOptionsToolkitV1.getConfigurableOptions(data));
    }
}

