/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.JfrOutlinePage;
import org.openjdk.jmc.flightrecorder.ui.PageManager;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.wizards.ExportToFileWizardPage;

public class PagesExportWizard
extends Wizard
implements IExportWizard {
    private static String WIZARD_KEY = "exportFlightRecordingPagesToFile";
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String FILE_ENDING = "xml";
    private ExportPagesWizardPage wizardPage;

    public boolean performFinish() {
        if (this.wizardPage.isExportToFileOk()) {
            block13: {
                HashSet<Object> pages = new HashSet<Object>(Arrays.asList(this.wizardPage.getSelectedItems()));
                Throwable throwable = null;
                Object var3_5 = null;
                FileOutputStream fos = new FileOutputStream(this.wizardPage.getFile());
                try {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), CHARSET);
                    StateToolkit.writeAsXml(state -> PageManager.savePages(pages, state), (Writer)osw);
                    this.wizardPage.storeFilename();
                    if (fos == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        DialogToolkit.showExceptionDialogAsync((Display)this.wizardPage.getControl().getDisplay(), (String)Messages.PAGE_EXPORT_ERROR_TITLE, (String)MessageFormat.format(Messages.PAGE_EXPORT_ERROR_MESSAGE, e.getLocalizedMessage()), (Throwable)e);
                    }
                }
                fos.close();
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(FlightRecorderUI.getDefault().getDialogSettings());
        this.wizardPage = new ExportPagesWizardPage();
        this.setWindowTitle(this.wizardPage.getTitle());
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean canFinish() {
        return this.wizardPage != null && this.wizardPage.isPageComplete();
    }

    private static class ExportPagesWizardPage
    extends ExportToFileWizardPage {
        private CheckboxTreeViewer ctw;

        public ExportPagesWizardPage() {
            super(WIZARD_KEY, PagesExportWizard.FILE_ENDING);
            this.setTitle(Messages.PAGE_EXPORT_WIZARD_TITLE);
        }

        protected Composite createContents(Composite parent) {
            this.ctw = new CheckboxTreeViewer(parent);
            this.ctw.setContentProvider((IContentProvider)JfrOutlinePage.CONTENT_PROVIDER);
            this.ctw.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((DataPageDescriptor)element).getName();
                }

                public Image getImage(Object element) {
                    return (Image)JFaceResources.getResources().get((DeviceResourceDescriptor)((DataPageDescriptor)element).getImageDescriptor());
                }
            });
            this.ctw.addCheckStateListener(change -> this.updatePageComplete());
            this.ctw.setInput(FlightRecorderUI.getDefault().getPageManager().getRootPages());
            return this.ctw.getTree();
        }

        protected boolean isSelectionValid() {
            Object[] selected = this.getSelectedItems();
            return selected != null && selected.length > 0;
        }

        public Object[] getSelectedItems() {
            return this.ctw.getCheckedElements();
        }
    }
}

