/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.tree.IParent;
import org.openjdk.jmc.flightrecorder.ui.EventTypeFolderNode;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.ui.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.common.util.FilterMatcher;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class TypeFilterBuilder {
    private static final IElementComparer TYPE_COMPARER = new IElementComparer(){

        public boolean equals(Object a, Object b) {
            if (a instanceof EventTypeFolderNode.EventTypeNode) {
                a = ((EventTypeFolderNode.EventTypeNode)a).getType().getIdentifier();
            }
            if (b instanceof EventTypeFolderNode.EventTypeNode) {
                b = ((EventTypeFolderNode.EventTypeNode)b).getType().getIdentifier();
            }
            return Objects.equals(a, b);
        }

        public int hashCode(Object element) {
            if (element instanceof EventTypeFolderNode.EventTypeNode) {
                return ((EventTypeFolderNode.EventTypeNode)element).getType().getIdentifier().hashCode();
            }
            return Objects.hashCode(element);
        }
    };
    private final TreeViewer viewer;
    private Collection<String> missingTypes = Collections.emptyList();
    private Composite comp;
    private MCContextMenuManager menuManager;

    public TypeFilterBuilder(Composite parent, Runnable onChange) {
        this(parent, onChange, true);
    }

    public TypeFilterBuilder(Composite parent, Runnable onChange, boolean checkedTree) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.viewer = checkedTree ? new ContainerCheckedTreeViewer(this.comp, 0) : new TreeViewer(this.comp, 2);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setComparer(TYPE_COMPARER);
        LabelProvider lp = new LabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)lp);
        this.viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.menuManager = MCContextMenuManager.create((Control)this.viewer.getControl());
        Text filterText = TreeFilter.addFilterControl(this.comp, (StructuredViewer)this.viewer, e -> lp.getText(e).getString());
        filterText.moveAbove(this.viewer.getControl());
        if (checkedTree) {
            ((ContainerCheckedTreeViewer)this.viewer).addCheckStateListener(e -> onChange.run());
        } else {
            this.viewer.addSelectionChangedListener(e -> onChange.run());
        }
    }

    public void setInput(EventTypeFolderNode root) {
        this.viewer.setInput((Object)root);
        this.viewer.getTree().setRedraw(false);
        try {
            this.viewer.expandAll();
        }
        finally {
            this.viewer.getTree().setRedraw(true);
        }
        this.missingTypes = Collections.emptyList();
    }

    public Control getControl() {
        return this.comp;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void selectTypes(Set<String> typeToSelect) {
        HashSet<String> types = new HashSet<String>(typeToSelect);
        if (this.viewer instanceof CheckboxTreeViewer) {
            ((CheckboxTreeViewer)this.viewer).setCheckedElements(types.toArray());
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection(types.toArray()));
        }
        this.getCheckedTypeIds().forEach(types::remove);
        this.missingTypes = types;
    }

    public Stream<String> getCheckedTypeIds() {
        return Stream.concat(this.missingTypes.stream(), this.getSelectedTypes().map(n -> n.getType().getIdentifier()));
    }

    List<IType<IItem>> getAllTypes() {
        return TypeFilterBuilder.getLeafs(((EventTypeFolderNode)this.viewer.getInput()).getChildren().stream()).map(n -> n.getType()).collect(Collectors.toList());
    }

    public Stream<EventTypeFolderNode.EventTypeNode> getSelectedTypes() {
        if (this.viewer instanceof CheckboxTreeViewer) {
            return Stream.of(((CheckboxTreeViewer)this.viewer).getCheckedElements()).filter(o -> o instanceof EventTypeFolderNode.EventTypeNode).map(o -> (EventTypeFolderNode.EventTypeNode)o);
        }
        return TypeFilterBuilder.getLeafs(((StructuredSelection)this.viewer.getSelection()).toList().stream());
    }

    private static Stream<EventTypeFolderNode.EventTypeNode> getLeafs(Stream<?> nodes) {
        return nodes.flatMap(n -> n instanceof EventTypeFolderNode ? TypeFilterBuilder.getLeafs(((EventTypeFolderNode)n).getChildren().stream()) : Stream.of((EventTypeFolderNode.EventTypeNode)n));
    }

    public MCContextMenuManager getMenuManager() {
        return this.menuManager;
    }

    private static class LabelProvider
    extends StyledCellLabelProvider {
        private LabelProvider() {
        }

        public void update(ViewerCell cell) {
            StyledString text = this.getText(cell.getElement());
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private StyledString getText(Object element) {
            if (element instanceof EventTypeFolderNode) {
                EventTypeFolderNode n = (EventTypeFolderNode)element;
                return new StyledString(n.getName() + " ").append(n.getCount().displayUsing("auto"), StyledString.COUNTER_STYLER);
            }
            if (element instanceof EventTypeFolderNode.EventTypeNode) {
                EventTypeFolderNode.EventTypeNode n = (EventTypeFolderNode.EventTypeNode)element;
                return new StyledString(n.getType().getName() + " ").append(n.getCount().displayUsing("auto"), StyledString.COUNTER_STYLER);
            }
            return new StyledString();
        }

        public String getToolTipText(Object element) {
            if (element instanceof EventTypeFolderNode) {
                EventTypeFolderNode n = (EventTypeFolderNode)element;
                return n.getDescription() + "\n" + NLS.bind((String)org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages.EVENT_TYPE_TREE_NODE_TOOLTIP, (Object)n.getCount().displayUsing("exact"));
            }
            if (element instanceof EventTypeFolderNode.EventTypeNode) {
                EventTypeFolderNode.EventTypeNode n = (EventTypeFolderNode.EventTypeNode)element;
                String desc = n.getType().getDescription();
                String eventCount = NLS.bind((String)org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages.EVENT_TYPE_TREE_NODE_TOOLTIP, (Object)n.getCount().displayUsing("exact"));
                return desc == null ? eventCount : desc + "\n" + eventCount;
            }
            return super.getToolTipText(element);
        }

        private Image getImage(Object element) {
            if (element instanceof EventTypeFolderNode) {
                return UIPlugin.getDefault().getImage("fldr_obj.gif");
            }
            if (element instanceof EventTypeFolderNode.EventTypeNode) {
                return SWTColorToolkit.getColorThumbnail((Color)TypeLabelProvider.getColorOrDefault(((EventTypeFolderNode.EventTypeNode)element).getType().getIdentifier()));
            }
            return null;
        }
    }

    private static class TreeFilter
    extends ViewerFilter {
        private String filterString;
        private final Function<Object, String> labelProvider;
        private final Text filterText;
        private final StructuredViewer viewer;
        private final Set<Object> checkedCache;

        private static Text addFilterControl(Composite filterComposite, StructuredViewer viewer, Function<Object, String> lp) {
            TreeFilter filter = new TreeFilter(filterComposite, viewer, lp);
            return filter.filterText;
        }

        private TreeFilter(Composite filterComposite, final StructuredViewer viewer, Function<Object, String> lp) {
            this.labelProvider = lp;
            this.viewer = viewer;
            this.filterText = new Text(filterComposite, 128);
            this.filterText.setMessage(org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages.SEARCH_TREE_TEXT);
            this.filterText.setToolTipText(Messages.SEARCH_KLEENE_OR_REGEXP_TOOLTIP);
            this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.checkedCache = new HashSet<Object>();
            if (viewer instanceof CheckboxTreeViewer) {
                CheckboxTreeViewer checkedViewer = (CheckboxTreeViewer)viewer;
                Object[] objectArray = checkedViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object checked = objectArray[n2];
                    this.trackCheckedTree(checked);
                    ++n2;
                }
                checkedViewer.addCheckStateListener(new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        this.trackCheckedTree(event.getElement());
                    }
                });
            }
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = filterText.getText();
                    filterString = text == null ? null : FilterMatcher.autoAddKleene((String)text, (FilterMatcher.Where)FilterMatcher.Where.BEFORE_AND_AFTER);
                    viewer.refresh();
                    Object[] checkedElements = checkedCache.toArray();
                    if (viewer instanceof CheckboxTreeViewer) {
                        viewer.refresh();
                        ((CheckboxTreeViewer)viewer).setCheckedElements(checkedElements);
                    }
                }
            });
            viewer.addFilter((ViewerFilter)this);
        }

        private void trackCheckedTree(Object element) {
            if (this.viewer instanceof CheckboxTreeViewer) {
                CheckboxTreeViewer checkedViewer = (CheckboxTreeViewer)this.viewer;
                if (element instanceof IParent) {
                    Object[] objectArray = ((IParent)element).getChildren().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        this.trackCheckedTree(child);
                        ++n2;
                    }
                } else {
                    boolean affected;
                    boolean checked = checkedViewer.getChecked(element) && !checkedViewer.getGrayed(element);
                    boolean bl = affected = this.filterString == null || this.matches(element);
                    if (affected) {
                        if (checked) {
                            this.checkedCache.add(element);
                        } else {
                            this.checkedCache.remove(element);
                        }
                    }
                }
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.filterString == null) {
                return true;
            }
            if (this.isLeaf(element)) {
                return this.matches(element);
            }
            StructuredViewer sviewer = (StructuredViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
            Object[] objectArray = provider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.select(viewer, element, child)) {
                    if (viewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)viewer).setExpandedState(element, true);
                    }
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean isLeaf(Object element) {
            return element instanceof EventTypeFolderNode.EventTypeNode;
        }

        private boolean matches(Object element) {
            String label = this.labelProvider.apply(element);
            if (element instanceof EventTypeFolderNode.EventTypeNode) {
                label = label.concat(" " + ((EventTypeFolderNode.EventTypeNode)element).getType().getIdentifier());
            }
            return FilterMatcher.getInstance().match(label, this.filterString, true);
        }
    }
}

