/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.system;

import java.util.Arrays;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.system.ServerInformationModelBuilder;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class TableInformationSectionPart
extends MCSectionPart {
    private final ColumnManager columnManager;

    public TableInformationSectionPart(Composite parent, FormToolkit toolkit, IConnectionHandle connection, IMemento state) {
        super(parent, toolkit, Messages.SECTION_SERVER_INFORMATION_TITLE);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Table table = toolkit.createTable(body, 66306);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        IColumn categoryColumn = new ColumnBuilder(Messages.TABLE_CATEGORY_LABEL, "category", MemberAccessorToolkit.arrayElement((int)0)).description(Messages.TABLE_CATEGORY_DESC).build();
        IColumn valueColumn = new ColumnBuilder(Messages.TABLE_VALUE_LABEL, "value", MemberAccessorToolkit.arrayElement((int)1)).description(Messages.TABLE_VALUE_DESC).build();
        this.columnManager = ColumnManager.build((TableViewer)viewer, Arrays.asList(categoryColumn, valueColumn), (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)table));
        viewer.setInput((Object)ServerInformationModelBuilder.build(connection));
        this.columnManager.packColumns();
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }
}

