/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import org.openjdk.jmc.console.agent.manager.model.IPresetStorageDelegate;
import org.openjdk.jmc.console.agent.manager.model.PresetRepositoryFactory;

public class LocalStorageDelegate
implements IPresetStorageDelegate {
    private final File file;

    public static IPresetStorageDelegate getDelegate() throws IOException {
        File dir = PresetRepositoryFactory.getCreatedStorageDir();
        File file = File.createTempFile("preset-", ".xml", dir);
        return new LocalStorageDelegate(file);
    }

    public static IPresetStorageDelegate getDelegate(String fileName) throws IOException {
        File dir = PresetRepositoryFactory.getCreatedStorageDir();
        File file = new File(dir, fileName);
        return new LocalStorageDelegate(file);
    }

    public static IPresetStorageDelegate getDelegate(File file) {
        return new LocalStorageDelegate(file);
    }

    private LocalStorageDelegate(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream getContents() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public boolean save(String fileName, String fileContent) throws IOException {
        if (!this.file.getName().equals(fileName) && !this.file.renameTo(new File(PresetRepositoryFactory.getCreatedStorageDir(), fileName))) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);){
                out.write(fileContent);
                ((Writer)out).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (FileNotFoundException | IllegalCharsetNameException exception) {
            return false;
        }
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }
}

