/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs.StartRecordingJob;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizard;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class StartRecordingWizard
extends RecordingWizard {
    private final FlightRecorderProvider recorder;

    public StartRecordingWizard(RecordingWizardModel model, FlightRecorderProvider recorder) {
        super(model);
        this.recorder = recorder;
    }

    @Override
    public boolean performFinish() {
        boolean superFinish = super.performFinish();
        if (!superFinish) {
            return false;
        }
        this.startRecording(this.getModel());
        return true;
    }

    private void startRecording(RecordingWizardModel wizardModel) {
        try {
            IConstrainedMap<String> recordingOptions = wizardModel.buildOptions();
            StartRecordingJob sr = new StartRecordingJob(this.recorder, wizardModel.getName(), recordingOptions, wizardModel.getAndSaveEventSettings(), wizardModel.getPath());
            sr.schedule();
        }
        catch (IllegalArgumentException | QuantityConversionException e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.FLIGHT_RECORDING_OPTIONS_PROBLEM_TITLE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

