/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.ConfigurationRepositoryFactory;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationRepository;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.TemplateToolkit;
import org.openjdk.jmc.ui.wizards.SimpleImportFromFileWizardPage;

public class TemplateImportWizard
extends Wizard
implements IImportWizard {
    private static String WIZARD_KEY = "importTemplateFromFile";
    private SimpleImportFromFileWizardPage m_wizardPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)ControlPanel.getDefault().getDialogSettings(), (String)WIZARD_KEY));
        this.setWindowTitle(Messages.IMPORT_TEMPLATE_WIZARD_TITLE);
        this.m_wizardPage = new SimpleImportFromFileWizardPage(WIZARD_KEY, ".jfc");
        this.m_wizardPage.setTitle(Messages.IMPORT_TEMPLATE_WIZARD_TITLE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean performFinish() {
        File file = this.m_wizardPage.getFile();
        if (file != null) {
            EventConfigurationRepository repository = ConfigurationRepositoryFactory.create();
            List<IEventConfiguration> imported = TemplateToolkit.importFilesTo(repository, Collections.singleton(file));
            return !imported.isEmpty();
        }
        return false;
    }
}

