/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RenderedRowBase;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYQuantities;

public class XYDataRenderer
implements IXDataRenderer {
    private final ArrayList<SeriesEntry<?>> entries = new ArrayList();
    private final boolean axisOnLeft;
    private final IQuantity includeLow;
    private final IQuantity includeHigh;
    private final String name;
    private final String description;

    public XYDataRenderer(IQuantity include) {
        this(include, include);
    }

    public XYDataRenderer(IQuantity include, String name, String description) {
        this(include, include, true, name, description);
    }

    public XYDataRenderer(IQuantity includeLow, IQuantity includeHigh) {
        this(includeLow, includeHigh, true, null, null);
    }

    public XYDataRenderer(IQuantity includeLow, IQuantity includeHigh, boolean axisOnLeft, String name, String description) {
        this.axisOnLeft = axisOnLeft;
        this.includeLow = includeLow;
        this.includeHigh = includeHigh;
        this.name = name;
        this.description = description;
    }

    public <T> void addBarChart(String title, IQuantitySeries<T[]> series, Color color) {
        this.entries.add(new BarSeriesEntry(title, series, null, color));
    }

    public <T> void addBarChart(String title, IQuantitySeries<T[]> series, AWTChartToolkit.IColorProvider<? super T> cp) {
        this.entries.add(new BarSeriesEntry<T>(title, series, cp, null));
    }

    public <T> void addLineChart(String title, IQuantitySeries<T> series, Color color, boolean fill) {
        this.entries.add(new LineSeriesEntry<T>(title, series, color, fill, true));
    }

    public <T> void addPlotChart(String title, IQuantitySeries<T> series, Color color, boolean fill) {
        this.entries.add(new LineSeriesEntry<T>(title, series, color, fill, false));
    }

    @Override
    public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
        int width = xRange.getPixelExtent();
        IQuantity yAxisMin = this.includeLow;
        IQuantity yAxisMax = this.includeHigh;
        for (SeriesEntry<?> se : this.entries) {
            se.updatePointsCache(xRange);
            if (se.points.getSize() <= 0) continue;
            IQuantity seriesMinY = se.points.getMinY();
            if (yAxisMin == null || yAxisMin.compareTo((Object)seriesMinY) > 0) {
                yAxisMin = seriesMinY;
            }
            IQuantity seriesMaxY = se.points.getMaxY();
            if (yAxisMax != null && yAxisMax.compareTo((Object)seriesMaxY) >= 0) continue;
            yAxisMax = seriesMaxY;
        }
        if (yAxisMin != null && yAxisMax != null) {
            FontMetrics fm = context.getFontMetrics();
            if (yAxisMin.compareTo((Object)yAxisMax) == 0) {
                int offset = yAxisMin.getUnit() == UnitLookup.BYTE ? 1024 : 1;
                yAxisMax = yAxisMin.getUnit().quantity(yAxisMin.doubleValue() + (double)offset);
            } else {
                double padFactor = (double)(height + 1 + fm.getAscent() / 2) / (double)height;
                yAxisMax = yAxisMin.add(yAxisMax.subtract(yAxisMin).multiply(padFactor));
            }
            SubdividedQuantityRange yRange = new SubdividedQuantityRange(yAxisMin, yAxisMax, height, fm.getHeight());
            context.setPaint(Color.LIGHT_GRAY);
            AWTChartToolkit.drawGrid(context, yRange, width, true);
            Shape oldClip = context.getClip();
            context.setClip(new Rectangle(width, height));
            for (SeriesEntry<?> se : this.entries) {
                se.points.setYRange(yRange);
                if (se.points.getSize() <= 0) continue;
                if (se instanceof LineSeriesEntry) {
                    LineSeriesEntry lse = (LineSeriesEntry)se;
                    if (lse.connect) {
                        context.setPaint(lse.fill ? ColorToolkit.getGradientPaint((Color)lse.color, (int)height) : lse.color);
                        AWTChartToolkit.drawLineChart(context, se.points, width, height, lse.fill);
                        continue;
                    }
                    context.setPaint(lse.color);
                    AWTChartToolkit.drawPlot(context, se.points, height, lse.fill);
                    continue;
                }
                if (!(se instanceof BarSeriesEntry)) continue;
                XYDataRenderer.drawBarChart(context, (BarSeriesEntry)se, width, height);
            }
            context.setClip(oldClip);
            context.setPaint(Color.BLACK);
            if (this.axisOnLeft) {
                AWTChartToolkit.drawAxis(context, yRange, 0, true, 1, true);
            } else {
                AWTChartToolkit.drawAxis(context, yRange, width, false, 1, true);
            }
        }
        return new RenderedResult(height);
    }

    private static <T> void drawBarChart(Graphics2D context, BarSeriesEntry<T> se, int width, int height) {
        if (se.color != null) {
            context.setPaint(ColorToolkit.getGradientPaint((Color)se.color, (int)height));
        }
        AWTChartToolkit.drawBarChart(context, se.points, se.colorProvider, width, height);
    }

    private static class BarSeriesEntry<T>
    extends SeriesEntry<T[]> {
        private final String title;
        private final AWTChartToolkit.IColorProvider<? super T> colorProvider;
        private final Color color;

        BarSeriesEntry(String title, IQuantitySeries<T[]> series, AWTChartToolkit.IColorProvider<? super T> cp, Color color) {
            super(series);
            this.title = title;
            this.color = color;
            this.colorProvider = cp;
        }

        @Override
        void infoAt(IChartInfoVisitor visitor, int x, Point2D offset) {
            int bucket;
            if (this.points != null && (bucket = this.points.floorIndexAtX(x)) >= 0 && bucket < this.points.getSize()) {
                Object[] payload = (Object[])this.points.getPayload();
                Color col = this.color;
                if (this.colorProvider != null) {
                    col = this.colorProvider.getColor(payload != null ? payload[bucket] : null);
                }
                XYQuantities.Bucket bkt = new XYQuantities.Bucket(this.points, bucket, offset, this.title, col);
                visitor.visit(bkt);
            }
        }
    }

    private static class LineSeriesEntry<T>
    extends SeriesEntry<T> {
        private final String title;
        private final boolean fill;
        private final boolean connect;
        private final Color color;

        LineSeriesEntry(String title, IQuantitySeries<T> series, Color color, boolean fill, boolean connect) {
            super(series);
            this.title = title;
            this.color = color;
            this.fill = fill;
            this.connect = connect;
        }

        @Override
        void infoAt(IChartInfoVisitor visitor, int x, Point2D offset) {
            int size;
            int index;
            if (this.points != null && (index = Math.max(this.points.floorIndexAtX(x), 0)) < (size = this.points.getSize())) {
                if (index < size - 1) {
                    double currentX = this.points.getPixelX(index);
                    double nextX = this.points.getPixelX(index + 1);
                    if (currentX < 0.0 || nextX - (double)x < (double)x - currentX && nextX < (double)this.points.getWidth()) {
                        ++index;
                    }
                }
                XYQuantities.Point point = new XYQuantities.Point(this.points, index, offset, this.title, this.color);
                visitor.visit(point);
            }
        }
    }

    private class RenderedResult
    extends RenderedRowBase {
        private static final int TICK_ZONE_WIDTH = 32;

        public RenderedResult(int height) {
            super(Collections.emptyList(), height, XYDataRenderer.this.name, null, null);
        }

        @Override
        public void infoAt(IChartInfoVisitor visitor, int x, int y, final Point offset) {
            if (x >= 0) {
                for (SeriesEntry<?> se : XYDataRenderer.this.entries) {
                    se.infoAt(visitor, x, offset);
                }
            } else if (XYDataRenderer.this.axisOnLeft && !XYDataRenderer.this.entries.isEmpty() && x >= -32) {
                final SubdividedQuantityRange yRange = XYDataRenderer.this.entries.get((int)0).points.getYRange();
                final int index = yRange.getClosestSubdividerAtPixel(yRange.getPixelExtent() - 1 - y);
                visitor.visit(new IChartInfoVisitor.ITick(){

                    @Override
                    public IDisplayable getValue() {
                        return yRange.getSubdivider(index);
                    }

                    @Override
                    public Point2D getTarget() {
                        int y = offset.y + yRange.getPixelExtent() - 1 - (int)yRange.getSubdividerPixel(index);
                        return new Point(offset.x, y);
                    }
                });
            } else {
                visitor.visit(new IChartInfoVisitor.ILane(){

                    @Override
                    public String getLaneName() {
                        return ((RenderedResult)RenderedResult.this).XYDataRenderer.this.name;
                    }

                    @Override
                    public String getLaneDescription() {
                        return ((RenderedResult)RenderedResult.this).XYDataRenderer.this.description;
                    }
                });
            }
        }
    }

    private static abstract class SeriesEntry<U> {
        final IQuantitySeries<U> series;
        transient XYQuantities<U> points;

        SeriesEntry(IQuantitySeries<U> series) {
            this.series = series;
        }

        void updatePointsCache(SubdividedQuantityRange xRange) {
            if (this.points == null || !this.points.getXRange().equals(xRange)) {
                this.points = this.series.getQuantities(xRange);
            }
        }

        abstract void infoAt(IChartInfoVisitor var1, int var2, Point2D var3);
    }
}

