/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import org.eclipse.jface.resource.ImageDescriptor;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.misc.Messages;
import org.openjdk.jmc.ui.misc.OverlayImageDescriptor;

public class WarningDescriptorHelper {
    private String warningMessage = null;
    private String warningMessageLong = null;
    private final ImageDescriptor warningOverlay = UIPlugin.getDefault().getMCImageDescriptor("overlay_warning.gif");

    public String getName(String baseName) {
        return baseName + (String)(this.warningMessage != null ? " (" + this.warningMessage + ")" : "");
    }

    public String getDescription(String baseDescription) {
        return baseDescription + (String)(this.warningMessage != null ? " (" + this.warningMessageLong + ")" : "");
    }

    public void setWarning(String message) {
        this.warningMessage = Messages.AbstractWarningItem_WARNING;
        this.warningMessageLong = Messages.AbstractWarningItem_WARNING + ": " + message;
    }

    public void setSpecificWarning(String message) {
        this.warningMessage = message;
        this.warningMessageLong = message;
    }

    public void resetWarning() {
        this.warningMessage = null;
        this.warningMessageLong = null;
    }

    public ImageDescriptor getImageDescriptor(ImageDescriptor baseImageDescriptor) {
        return new OverlayImageDescriptor(baseImageDescriptor, false, this.warningMessage == null ? null : this.warningOverlay);
    }
}

