/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.core.ui;

import io.github.bric3.fireplace.core.ui.LightDarkColor;
import java.awt.Color;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.UIManager;

public class Colors {
    public static final int H = 0;
    public static final int S = 1;
    public static final int L = 2;
    public static final int ALPHA = 3;
    private static volatile boolean darkMode = false;
    public static final int DARK_PERCEIVED_BRIGHTNESS_THRESHOLD = Colors.gammaFunction(0.45);
    public static final Color blue = new LightDarkColor(Color.decode("#2B4EFF"), Color.decode("#39ACE7"));
    public static Color translucent_black_D0 = new Color(-805306368, true);
    public static final Color translucent_black_B0 = new Color(-1342177280, true);
    public static final Color translucent_black_80 = new Color(Integer.MIN_VALUE, true);
    public static Color translucent_black_60 = new Color(0x60000000, true);
    public static final Color translucent_black_40 = new Color(0x40000000, true);
    public static Color translucent_black_20 = new Color(0x20000000, true);
    public static final Color translucent_black_10 = new Color(0x10000000, true);
    public static final Color translucent_white_D0 = new Color(-788529153, true);
    public static final Color translucent_white_B0 = new Color(-1325400065, true);
    public static final Color translucent_white_80 = new Color(-2130706433, true);
    public static Color translucent_white_60 = new Color(0x60FFFFFF, true);
    public static Color translucent_white_40 = new Color(0x40FFFFFF, true);
    public static Color translucent_white_20 = new Color(0x20FFFFFF, true);
    public static Color translucent_white_10 = new Color(0x10FFFFFF, true);
    public static Color panelBackground = UIManager.getColor("Panel.background");
    public static Color panelForeground = UIManager.getColor("Panel.foreground");
    private static final float DARKER_FACTOR = 0.7f;
    private static final float BRIGHTER_FACTOR = 1.4285715f;

    public static void refreshColors() {
        panelBackground = UIManager.getColor("Panel.background");
        panelForeground = UIManager.getColor("Panel.foreground");
    }

    public static boolean isDarkMode() {
        return darkMode;
    }

    public static void setDarkMode(boolean darkMode) {
        Colors.darkMode = darkMode;
        Colors.refreshColors();
    }

    private Colors() {
    }

    public static Color foregroundColor(Color backgroundColor) {
        boolean isBright = Colors.isBright(backgroundColor);
        return isBright ? (darkMode ? panelBackground : panelForeground) : Color.white;
    }

    public static boolean isBright(Color color) {
        int brightness = Colors.brightness(color);
        boolean isBright = brightness >= DARK_PERCEIVED_BRIGHTNESS_THRESHOLD;
        return isBright;
    }

    public static int brightness(Color color) {
        double rY = 0.212655;
        double gY = 0.715158;
        double bY = 0.072187;
        return Colors.gammaFunction(rY * Colors.inverseOfGammaFunction(color.getRed()) + gY * Colors.inverseOfGammaFunction(color.getGreen()) + bY * Colors.inverseOfGammaFunction(color.getBlue()));
    }

    private static int gammaFunction(double v) {
        v = v <= 0.0031308 ? (v *= 12.92) : 1.055 * Math.pow(v, 0.4166666666666667) - 0.055;
        return (int)Math.round(v * 255.0);
    }

    private static double inverseOfGammaFunction(int ic) {
        double c = (double)ic / 255.0;
        if (c <= 0.03928) {
            return c / 12.92;
        }
        return Math.pow((c + 0.055) / 1.055, 2.4);
    }

    public static Color blend(Color c0, Color c1) {
        double totalAlpha = c0.getAlpha() + c1.getAlpha();
        double weight0 = (double)c0.getAlpha() / totalAlpha;
        double weight1 = (double)c1.getAlpha() / totalAlpha;
        double r = weight0 * (double)c0.getRed() + weight1 * (double)c1.getRed();
        double g = weight0 * (double)c0.getGreen() + weight1 * (double)c1.getGreen();
        double b = weight0 * (double)c0.getBlue() + weight1 * (double)c1.getBlue();
        double a = Math.max(c0.getAlpha(), c1.getAlpha());
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    public static Color dim(Color color) {
        float[] hslaLight = Colors.hslaComponents(color);
        float[] hslaDark = Arrays.copyOf(hslaLight, hslaLight.length);
        float f = hslaDark[1] < 0.1f ? hslaDark[1] : 0.2f;
        hslaDark[1] = f;
        hslaDark[2] = 0.2f;
        hslaLight[1] = (double)hslaLight[1] < 0.2 ? hslaLight[1] : 0.4f;
        hslaLight[2] = 0.93f;
        return new LightDarkColor(Colors.hsla(hslaLight[0], hslaLight[1], hslaLight[2], hslaLight[3]), Colors.hsla(hslaDark[0], hslaDark[1], hslaDark[2], hslaDark[3]));
    }

    public static Color brighter(Color color, float k) {
        return Colors.brighter(color, k, 1.0f);
    }

    public static Color brighter(Color color, float k, float maxLuminance) {
        Colors.checkThat(k < 0.0f, "k must be positive");
        Colors.checkThat(maxLuminance < 0.0f || maxLuminance > 1.0f, "maxLuminance [0; 1], actual: " + maxLuminance);
        double factor = k == 0.0f ? 1.4285714626312256 : Math.pow(1.4285714626312256, k);
        float[] hsla = Colors.hslaComponents(color);
        return Colors.hsla(hsla[0], hsla[1], Math.min((float)((double)hsla[2] * factor), maxLuminance), hsla[3]);
    }

    public static Color darker(Color color, float k) {
        return Colors.darker(color, k, 0.0f);
    }

    public static Color darker(Color color, float k, float minLuminance) {
        Colors.checkThat(k < 0.0f, "k must be positive");
        Colors.checkThat(minLuminance < 0.0f || minLuminance > 1.0f, "maxLuminance [0; 1], actual: " + minLuminance);
        double factor = k == 0.0f ? (double)0.7f : Math.pow(0.7f, k);
        float[] hsla = Colors.hslaComponents(color);
        return Colors.hsla(hsla[0], hsla[1], Math.max((float)((double)hsla[2] * factor), minLuminance), hsla[3]);
    }

    public static float[] hslaComponents(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        float s = max - min;
        float l = (max + min) / 2.0f;
        if (s >= 0.0f) {
            h = r == max ? (g - b) / s + (float)(g < b ? 6 : 0) : (g == max ? (b - r) / s + 2.0f : (r - g) / s + 4.0f);
            s /= (double)l < 0.5 ? max + min : 2.0f - max - min;
            h *= 60.0f;
        } else {
            s = l > 0.0f && l < 1.0f ? 0.0f : h;
        }
        return new float[]{h, s, l, alpha};
    }

    public static Color hsla(float h, float s, float l, float alpha) {
        h = h % 360.0f + (float)(h < 0.0f ? 360 : 0);
        s = Float.isNaN(h) || Float.isNaN(s) ? 0.0f : s;
        Colors.checkThat(s < 0.0f || s > 1.0f, "Saturation [0; 1], actual: " + s);
        Colors.checkThat(l < 0.0f || l > 1.0f, "Luminance [0; 1], actual: " + l);
        Colors.checkThat(alpha < 0.0f || alpha > 1.0f, "Alpha [0; 1], actual: " + alpha);
        float m2 = l + ((double)l < 0.5 ? l : 1.0f - l) * s;
        float m1 = 2.0f * l - m2;
        return new Color((int)(alpha * 255.0f) << 24 | Colors.hueToRgb(h >= 240.0f ? h - 240.0f : h + 120.0f, m1, m2) << 16 | Colors.hueToRgb(h, m1, m2) << 8 | Colors.hueToRgb(h < 120.0f ? h + 240.0f : h - 120.0f, m1, m2));
    }

    private static int hueToRgb(float h, float m1, float m2) {
        return (int)((h < 60.0f ? m1 + (m2 - m1) * h / 60.0f : (h < 180.0f ? m2 : (h < 240.0f ? m1 + (m2 - m1) * (240.0f - h) / 60.0f : m1))) * 255.0f);
    }

    public static Color rgba(int r, int g, int b, float a) {
        return new Color(r, g, b, (int)(a * 255.0f));
    }

    public static String toHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static void checkThat(boolean invalid, String message) {
        if (invalid) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void printLafColorProperties() {
        UIManager.getLookAndFeelDefaults().entrySet().stream().filter(e -> e.getValue() instanceof Color).map(e -> e.getKey() + ": " + String.format("#%06X", 0xFFFFFF & ((Color)e.getValue()).getRGB())).sorted().forEach(System.out::println);
    }

    public static enum Palette {
        LIGHT_BLACK_TO_YELLOW("#03071e", "#370617", "#6a040f", "#9d0208", "#d00000", "#dc2f02", "#e85d04", "#f48c06", "#faa307", "#ffba08"),
        LIGHT_RED_TO_BLUE("#f94144", "#f3722c", "#f8961e", "#f9c74f", "#90be6d", "#43aa8b", "#577590"),
        LIGHT_VIOLET_TO_ORANGE("#54478c", "#2c699a", "#048ba8", "#0db39e", "#16db93", "#83e377", "#b9e769", "#efea5a", "#f1c453", "#f29e4c"),
        LIGHT_BLACK_TO_BEIGE_TO_RED("#001219", "#005f73", "#0a9396", "#94d2bd", "#e9d8a6", "#ee9b00", "#ca6702", "#bb3e03", "#ae2012", "#9b2226"),
        DARK_BLACK_TO_SLATE("#000000", "#241327", "#301934", "#3e1f3d", "#4c2445", "#5a2a4d", "#682f55", "#46324c", "#353347", "#243442"),
        DARK_GREENY_TO_VIOLET("#006466", "#065a60", "#0b525b", "#144552", "#1b3a4b", "#212f45", "#272640", "#312244", "#3e1f47", "#4d194d"),
        DARK_LIGHT("#E91E63", "#C2185B", "#9C27B0", "#5727B0", "#272AB0", "#2768B0", "#57ACDC", "#57DCBE", "#60C689"),
        DARK_CUSTOM("#54B03B", "#2D8684", "#C2AB47", "#66CCB9", "#A1DD98", "#9D5B34", "#A190DA", "#623BB0", "#CF776E", "#DDD598", "#F2E30D"),
        DARK_BLUE_GREEN_ORANGE_RED("#178FFF", "#45A5FF", "#73BCFF", "#A2D2FF", "#15CB49", "#44D566D", "#73E092", "#73E092", "#FF9E2E", "#FFB157", "#FFC581", "#FFD9AB", "#F74241", "#F96767", "#FA8D8D", "#FCB3B3", "#FFE8B3", "#FFF2D9", "#FFF5E3", "#FFF8F6", "#8C2DFF", "#B14BFF", "#D069FF", "#E891FF"),
        LIGHT_BLUE_GREEN_ORANGE_RED("#003565", "#004F99", "#1272CB", "#0084FF", "#014A15", "#00701F", "#009529", "#00BA34", "#643600", "#955000", "#C76B00", "#F98600", "#5D1113", "#8C1A19", "#BA2323", "#E92C2B", "#FFD966", "#FFE8A0", "#FFF0C6", "#FFF4E0", "#5D00A8", "#9E00C9", "#D300E9", "#FF00FF"),
        DATADOG(new Color(0x3399CC), new Color(9600953), new Color(0xFFCC00), new Color(5748634), new Color(12473275), new Color(14517329), new Color(3762611), new Color(12505111), new Color(8991908), new Color(0x3BCBCB), new Color(7236044), new Color(5280543), new Color(13134708), new Color(16559915), new Color(3059934), new Color(13012173), new Color(0x457557), new Color(13384817), new Color(9982083), new Color(10990402)),
        PYROSCOPE(new Color(14650195), new Color(14724460), new Color(6862799), new Color(5882019), new Color(6854602), new Color(9011913), new Color(15444198), new Color(16769397), new Color(12049323), new Color(16045464), new Color(7396333), new Color(16366223), new Color(15896977), new Color(8566232), new Color(15050978), new Color(11444960), new Color(10142858), new Color(15911277), new Color(6669787), new Color(16356174), new Color(15361120), new Color(5346766), new Color(14058446), new Color(8416951));

        private final Color[] palette;

        private Palette(String ... hexacodes) {
            this.palette = (Color[])Arrays.stream(hexacodes).flatMap(hex -> Pattern.compile("[-, ]").splitAsStream((CharSequence)hex)).map(s -> s.charAt(0) == '#' ? s : "#" + s).map(Color::decode).toArray(Color[]::new);
            Colors.checkThat(this.palette.length == 0, "Invalid color palette: " + Arrays.toString(hexacodes));
        }

        private Palette(Color ... palette) {
            this.palette = palette;
        }

        public Color[] colors() {
            return this.palette;
        }
    }
}

